import req from '@/request'

const portal = window.context.portal

// 拖车部门汇总统计
export function CallLeder(data) {
  let queryData = {
    'endTime': '',
    'orgList': [],
    'startTime': ''
  }
  const {querys = []} = data
  let taskDate = querys.find(item => item.property == 'rescueTime')
  if (taskDate) {
    queryData.startTime = taskDate.value[0]
    queryData.endTime = taskDate.value[1]
  }
  let orgData = querys.find(item => item.property == 'road_id_')
  if (orgData) {
    queryData.orgList = orgData.value
  }
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizCallAgents/v1/countCall`, queryData)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'CallLeder'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

