import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBaseRoad/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 同步数据
export function synchroData() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizBaseRoad/v1/SynchronizeData`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizBaseRoad/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 获取组织架构
export function getTree() {
    return new Promise((resolve, reject) => {
        req.get(portal + `/uc/org/roadTree`)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 获取路段巡查配置
export function getRoadConfig(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizBaseRoad/v1/getConfig/` + id)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 更新路段巡查配置
export function updateRoadConfig(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizBaseRoad/v1/updateConfig`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}