import req from '@/request'

const portal = window.context.portal

// 获取组织架构
export function getTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizElectronicFenec/v1/fenecTree`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 点位保存
export function pointSaving(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizElectronicFenec/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 点位修改
export function editPointSaving(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizElectronicFenec/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function getFenec(data) {
  let teamIds = data.join(',')
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizElectronicFenec/v1/getFenec?teamIds=${teamIds}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

export function tableDelete(teamIds) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizElectronicFenec/v1/delete/${teamIds}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}