import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizInfoPublishRecord/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格保存
export function tableSave(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizInfoPublishRecord/v1/saveBatch`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizInfoPublishRecord/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出数据
export function exportData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizInfoPublishRecord/v1/export`, data, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}