import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizDutyRecord/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizDutyRecord/v1/${id}`)
        .then(res => resolve(res?.data || {}))
        .catch(err => reject(err))
    })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizDutyRecord/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/bizDutyRecord/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/bizDutyRecord/v1/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取值班人员
export function getDutyPerson() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizRankUser/v1/today/users`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 获取接班人员
export function getReplacePerson() {
  return new Promise((resolve, reject) => {
    req.get(portal + `/bizRankUser/v1/next-rank/users`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 批量导出数据
export function exportDataBatch(ids) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/bizDutyRecord/v1/export?${ids}`, {}, 'blob')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
