import req from '@/request'

const portal = window.context.portal

// 新增拥堵
export function trafficJamAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizTrafficCongestion/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获取详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/event/bizEventInfo/v1/full/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 更新拥堵
export function trafficJamEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizTrafficCongestion/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除拥堵
export function trafficJamDelete(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizTrafficCongestion/v1/` + id)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增管制
export function trafficControlAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizTrafficControl/v1/list/save`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 更新管制
export function trafficControlEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizTrafficControl/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除管制
export function trafficControlDelete(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizTrafficControl/v1/` + id)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增路产赔偿清单
export function compensationAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizCompensationDetails/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 更新路产赔偿清单
export function compensationEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizCompensationDetails/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除路产赔偿清单
export function compensationDelete(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizCompensationDetails/v1/` + id)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 新增救援费用
export function rescueFeeAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueCost/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 更新救援费用
export function rescueFeeEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/event/bizRescueCost/v1/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 删除救援费用
export function rescueFeeDelete(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/event/bizRescueCost/v1/` + id)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 救援单查询
export function rescueInfoData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizRescueInfo/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 弹层保存
export function saveList(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizEventInfo/v1/end`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
