import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/exam/paper/base/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 成绩公布
export function pushPaper(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/exam/paper/base/pushPaper?id=${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 成绩查询
export function userRecordQuery(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/exam/user/record/userRecordQuery`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 导出
export function userRecordExport(id) {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/exam/paper/base/export/` + id)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}




