import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/paper/setting/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/exam/paper/setting/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/paper/setting/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/exam/paper/setting/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/exam/paper/setting/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 专业培训科目树
export function majorTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/subject/info/getTree`)
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}

// 新人培训科目树
export function newComerTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/freshman/subject/getTree`)
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}


// 根据科目或专题id获取考题
export function findByQuestionBankType(data) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/exam/questions/info/findByQuestionBankType?${qs.stringify(data)}`)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}


