/*
* ✨ 样式工具类函数 ✨
* */


/**
 * 将Hex颜色值转换为带有透明度的RGBA字符串
 * @param {String} hex Hex颜色值
 * @param {Number} opacity 透明度
 * @return {String} 带有透明度的RGBA字符串
 * */
export function convertHexToRGBA(hex = '', opacity = 1) {
  if (!hex) return 'auto'
  let r = parseInt(hex.slice(1, 3), 16),
    g = parseInt(hex.slice(3, 5), 16),
    b = parseInt(hex.slice(5, 7), 16)

  return `rgba(${r}, ${g}, ${b}, ${opacity})`
}



