/**
 * 公共混入方法
 * 包含：
 * handleDbClick    双击修改
 * handleDetailPage  查看详情
 * calcTableHeight   动态计算列表高度
 * */
import {setQueryValue, setSorterDirection} from '@/utils/requestWrappers'

export const TableMixin = {
  props: {
    componentName: {
      default: 'TablePage',
      type: String
    }
  },
  data() {
    return {
      tableMaxHeight: 600,
      // tableLoading: true, // 不可加入
      // treeLoading: true, // 不可加入
      params: {
        pageBean: {pageSize: 20, page: 1, total: 0},
        querys: [],
        sorter: []
      },
      currentDataDel: [],
      clickTimer: false
    }
  },
  watch: {
    componentName(newVal) {
      if (newVal === this.$options.name) {
        this.openPage()
      } else {
        this.closePage()
      }
    }
  },
  mounted() {
    this.calcTableHeight()
    this.$root.$on('resize', () => {
      this.calcTableHeight(500)
    })
  },
  created() {

  },
  methods: {
    // 打开页面执行
    openPage() {
      this.clickTimer = false
      this.calcTableHeight()
    },

    // 关闭页面执行
    closePage() {
    },

    // 双击修改
    handleDbClick(row) {
      if (this.clickTimer) return (this.clickTimer = false)
      this.changePage('EditAddPage', row)
    },

    // 排序切换
    sortChange({prop, order}) {
      this.params.pageBean.page = 1
      let direction = ''
      switch (order) {
        case 'ascending':
          direction = 'ASC'
          break
        case 'descending':
          direction = 'DESC'
          break
      }
      setSorterDirection(this.params, prop, direction)
      this.loadData()
    },

    //  表格勾选触发事件
    handleSelection() {
      this.clickTimer = true
    },

    //表格选中
    handleSelectionChange(val) {
      setTimeout(_ => this.clickTimer = false) // 抛入宏任务队列，交由下个事件循环执行
      this.currentDataDel = val.map((item) => item.id)
    },

    // 顶部搜索
    handleSearch(data) {
      this.params.pageBean.page = 1
      data.forEach((item) => {
        if (Array.isArray(item.prop) && item.prop.length) {
          item.prop.forEach(prop => setQueryValue(this.params, prop, item.value))
        } else if (typeof item.prop === 'string') {
          setQueryValue(this.params, item.prop, item.value)
        }
      })
      this.loadData()
    },

    // 详情
    handleDetailPage(row = {}) {
      this.clickTimer = true
      this.changePage('DetailPage', row)
    },

    //分页页数切换
    handleCurrentChange(page = 1) {
      if (!this.params?.pageBean?.page) return
      this.params.pageBean.page = page
      this.loadData()
    },

    //分页大小切换
    handleSizeChange(pageSize = 10) {
      if (!this.params?.pageBean?.page) return
      this.params.pageBean.pageSize = pageSize
      this.loadData()
    },

    // 计算表格高度
    calcTableHeight(delay = 0) {
      // 动态计算表格的高度，自适应当前容器
      setTimeout(() => {
        if (!this.$refs.tableRef) return
        const contentPanelHeight =
          this.$refs.tableRef && this.$refs.tableRef.clientHeight
        const paginationPanelHeight = this.$refs.paginationPanel ? 32 : 0
        this.tableMaxHeight = contentPanelHeight - paginationPanelHeight - 32
      }, delay || 0)
    }
  }
}
