import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/monitor/bizComplaintManagement/v1/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/monitor/bizComplaintManagement/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/monitor/bizComplaintManagement/v1/`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/monitor/bizComplaintManagement/v1/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  let param = ''
  if (ids.indexOf(',') === -1) {
    param = `ids=${ids}`;
  }else{
    const idArray = ids.split(',');
    param = idArray.map(id => `ids=${id}`).join('&');
  }
  return new Promise((resolve, reject) => {
    req.remove(portal + `/monitor/bizComplaintManagement/v1/?${param}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function complaintTemplateDownload() {
  return new Promise((resolve, reject) => {
    req.downloadGet(portal + `/monitor/bizEarlyWarningManagement/v1/downloadMainTempFile`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}