import req from '@/request'

const portal = window.context.portal

// 路产单数量统计
export function RoadProductionList(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/event/bizCompensationInfo/v1/count/frequency`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'RoadProductionList'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 路产损失项目统计 (接口未出，待优化)
export function RoadProductionLossProject(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/patrol/bizInspectionTask/v1/count/user`, data)
      .then(res => {
        let resData = res.data || {}
        resData.urlKey = 'RoadProductionLossProject'
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 路产单数量统计导出
export function RoadProductionListExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/event/bizCompensationInfo/v1/count/frequency/export`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}

// 路产损失项目统计 (接口未出，待优化)导出
export function RoadProductionLossProjectExport(data) {
  return new Promise((resolve, reject) => {
    req.downloadPostCopy(portal + `/patrol/bizInspectionTask/v1/export/user`, data)
      .then(res => {
        let resData = res.data || {}
        resolve(resData)
      })
      .catch(err => reject(err))
  })
}