import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizEmergencyDrill/v1/query`, data)
            .then(res => resolve(res?.data || []))
            .catch(err => reject(err))
    })
}

// 表格详情
export function tableDetail(id) {
    return new Promise((resolve, reject) => {
        req.get(portal + `/bizEmergencyDrill/v1/${id}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格新增
export function tableAdd(data) {
    return new Promise((resolve, reject) => {
        req.post(portal + `/bizEmergencyDrill/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格删除
export function tableDelete(ids) {
    return new Promise((resolve, reject) => {
        req.remove(portal + `/bizEmergencyDrill/v1/?ids=${ids}`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 表格修改
export function tableEdit(data) {
    return new Promise((resolve, reject) => {
        req.put(portal + `/bizEmergencyDrill/v1/`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 模板下载
export function downloadModel() {
    return new Promise((resolve, reject) => {
        req.downloadGet(portal + `/bizEmergencyDrill/v1/downModel`)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}

// 明细导出
export function exportData(data) {
    return new Promise((resolve, reject) => {
        req.downloadPostCopy(portal + `/bizEmergencyDrill/v1/export`, data)
            .then(res => resolve(res?.data || {}))
            .catch(err => reject(err))
    })
}