import req from '@/request'

const portal = window.context.portal

// 获取目录
export function getTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/kh/subject/getTree`)
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}

// 目录详情
export function treeDetails(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/subject/${id}`)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录新增
export function treeAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/kh/subject/`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录修改
export function treeEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/kh/subject/`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 目录删除
export function treeDelete(id) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/kh/subject/${id}`)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}


// 目录授权
export function authorizeCompany(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/biz/policy/catalog/authorizeCompany`, data)
      .then(res => resolve(res.data || {}))
      .catch(err => reject(err))
  })
}

// 获得公司树
export function orgTree() {
  return new Promise((resolve, reject) => {
    req.get(portal + `//api/org/v1/user/getOrgTree?demCode=ljjt`)
      .then(res => resolve(res.data || []))
      .catch(err => reject(err))
  })
}

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/kh/indicators/library/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/kh/indicators/library/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/kh/indicators/library/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/kh/indicators/library/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/kh/indicators/library/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
