import req from '@/request'

const portal = window.context.portal

export function majorTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/subject/info/getTree`)
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}

export function newComerTree() {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/freshman/subject/getTree`)
      .then(res => resolve(res.data?.value || []))
      .catch(err => reject(err))
  })
}

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/questions/info/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/exam/questions/info/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/exam/questions/info/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/exam/questions/info/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/exam/questions/info/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 载导入模板
export function downModel() {
  return new Promise((resolve, reject) => {
    req.downloadGet(portal + `/exam/questions/info/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}



