import req from '@/request'

const portal = window.context.portal

// 表格分页
export function tableData(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/special/meeting/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/biz/special/meeting/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/special/meeting/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req.remove(portal + `/biz/special/meeting/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req.put(portal + `/biz/special/meeting/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 发起会议
export function meetingPush(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/biz/special/meeting/push?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 取消会议
export function meetingCancel(id) {
  return new Promise((resolve, reject) => {
    req.get(portal + `/biz/special/meeting/cancel?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 添加参会人员
export function addUser(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/special/meeting/addUser`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 记录会议成果
export function uploadResult(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/biz/special/meeting/uploadResult`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

