import req from '@/request'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    //分页查询
    queryData(data, cb) {
        req.post(portal + `/exam/paper/base/query`, data).then(res => {
            cb(res.data)
        })
    },
    //添加
    addData(data, cb) {
        req.post(portal + `/exam/paper/base/`, data).then(res => {
            cb(res.data)
        })
    },
    //编辑
    editData(data, cb) {
        req.put(portal + `/exam/paper/base/`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    deleteData(ids, cb) {
        req.remove(portal + `/exam/paper/base/?ids=${ids}`).then(res => {
            cb(res.data)
        })
    },
    //根据id查询
    detailsData(id, cb) {
        req.get(portal + `/exam/paper/base/${id}`).then(res => {
            cb(res.data)
        })
    },
    //发布试卷
    releaseTest(ids, cb) {
        req.get(portal + `/exam/paper/base/startPaper?ids=${ids}`).then(res => {
            cb(res.data)
        })
    },
    //公布试卷
    publishTest(ids, cb) {
        req.get(portal + `/exam/paper/base/pushPaper?id=${ids}`).then(res => {
            cb(res.data)
        })
    },
    //用户人员
    orgUserQuery(data, cb) {
        req.post(portal + `/api/user/v1/users/getOrgUserQuery`, data).then(res => {
            cb(res.data)
        })
    },
    //单位树
    orgTree(id, cb) {
        req.get(portal + `/api/org/v1/user/getOrgTree?demCode=ljjt&pOrgCode=`).then(res => {
            cb(res.data)
        })
    },
    //组织树
    treeDataByDem(id, cb) {
        req.get(portal + `/api/org/v1/orgs/treeDataByDem?demCode=ljjt&pOrgCode=`).then(res => {
            cb(res.data)
        })
    },
    //岗位
    jobQuery(data, cb) {
        req.post(portal + `/api/org/v1/orgPosts/getOrgPostPage`, data).then(res => {
            cb(res.data)
        })
    },
}
