import { SquarePatternCfg } from '../../types/pattern';
/**
 * squarePattern 的 默认配置
 */
export declare const defaultSquarePatternCfg: {
    size: number;
    padding: number;
    isStagger: boolean;
    backgroundColor: string;
    opacity: number;
    rotation: number;
    fill: string;
    fillOpacity: number;
    stroke: string;
    lineWidth: number;
};
/**
 * 绘制square
 *
 * @param context canvasContext
 * @param cfg squarePattern 的配置
 * @param x和y square的中心位置
 */
export declare function drawSquare(context: CanvasRenderingContext2D, cfg: SquarePatternCfg, x: number, y: number): void;
/**
 * 创建 squarePattern
 */
export declare function createSquarePattern(cfg?: SquarePatternCfg): CanvasPattern;
