/**
 * 获取混合方法
 */
export declare const innerBlend: (mode: string) => any;
/**
 * 混合颜色，并处理透明度情况
 * 参考：https://www.w3.org/TR/compositing/#blending
 * @param c0
 * @param c1
 * @param mode 混合模式
 * @return rbga
 */
export declare function blend(c0: string, c1: string, mode?: string): string;
/**
 * 统一颜色输入的格式 [r, g, b, a]
 * 参考：https://www.w3.org/TR/compositing/#blending
 * @param c color
 * @return [r, g, b, a]
 */
export declare function colorToArr(c: string): number[];
