package com.artfess.sysConfig.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

/**
 * <p>
 * 系统字典详情信息表
 * </p>
 *
 * @author ly
 * @since 2020-05-06
 */
@Data
@ApiModel(value = "SysDictionaryDetail Vo对象", description = "系统字典详情级联信息表")
public class DictionaryDetailVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字典值_ID")
    private String Id;

    @ApiModelProperty(value = "字典_ID【外键】")
    private String dictionaryId;

    @ApiModelProperty(value = "字典_名称")
    private String dictionaryName;

    @ApiModelProperty(value = "字典_编码")
    private String dictionaryCode;

    @ApiModelProperty(value = "字典_序号")
    private Integer dictionarySn;

    @ApiModelProperty(value = "成员名称")
    private String name;

    @ApiModelProperty(value = "成员数据值")
    private String value;

    @ApiModelProperty(value = "排序号")
    private Integer sequence;

    @ApiModelProperty(value = "下级字典")
    private Map lowerDic;

}
