import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 预警配置分页
    queryDataConfig(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizWarnConfig/v1/query`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 预警配置保存
    saveConfig(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizWarnConfig/v1/save`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 预警配置批量删除
    batchDeleteConfig(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/bizWarnConfig/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 预警信息分页
    queryDataInfo(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDeviceWarnInfo/v1/query`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 预警信息保存
    saveInfo(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDeviceWarnInfo/v1/`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
     // 添加编辑预警信息保存
    addInfo(data){
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDeviceWarnInfo/v1/save`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 预警信息更新
    updateInfo(data) {
        return new Promise((resolve, reject) => {
            req.put(portal + `/bizDeviceWarnInfo/v1/`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 预警信息批量删除
    batchDeleteInfo(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/bizDeviceWarnInfo/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 预警信息根据id查询
    queryOneWarnInfo(id){

        return new Promise((resolve, reject) => {
            req.get(portal + `/bizDeviceWarnInfo/v1/`+id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    }
}