import req from "@/request.js";
const portal = window.context.portal;
const headersUrlencoded = {
    'Content-type': 'application/x-www-form-urlencoded',
}
export default {
    // 位置分页查询
    queryPosition(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizPosition/v1/query`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 位置树查询
    queryPositionTree(data) {
        let param = {
            data,
            method: "post",
            headers: headersUrlencoded,
            url: portal + `/bizPosition/v1/queryTree`,
        }
        return new Promise((resolve, reject) => {
            req.request(param).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 新增位置
    addPosition(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizPosition/v1/`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 更新位置
    updatePosition(data) {
        return new Promise((resolve, reject) => {
            req.put(portal + `/bizPosition/v1/`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 删除位置
    delPosition(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/bizPosition/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 设备分页
    queryDeviceList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDevice/v1/page`, data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 根据id查设备
    queryById(id) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDevice/v1/get/` + id).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 设备保存
    saveDevice(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDevice/v1/save`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 设备删除
    batchDelete(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/bizDevice/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 设备控制查询
    queryDeviceControl(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDeviceContro/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 新增设备控制
    addDeviceControl(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizDeviceContro/v1/save`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 设备删除
    batchControlDelete(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/bizDeviceContro/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 保存设备排序号
    saveSort(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/bizDevice/v1/updateSequence', data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    }
}