import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 分页
    queryTollStation(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/tollstation/manager/v1/query`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    //提交
    batchSubmit(dialogForm) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/tollstation/manager/v1/save`, dialogForm).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    
    // 批量删除
    batchDelete(deleteIds) {
        return new Promise((resolve, reject) => {
            req.remove(portal + '/tollstation/manager/v1/?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 路段不分页查询
    queryRoad(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + '/bizRoadSection/v1/query', data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 收费站下人员查询
    queryWorker(data){
        return new Promise((resolve, reject) => {
            req.post(portal + '/tollstation/manager/v1/getAllUser',data).then(
                res => {
                    resolve(res.data)
                },
                error => {
                    reject(error)
                });
        })
    }
}