package com.artfess.bpm.persistence.model;
import org.apache.commons.lang.builder.ToStringBuilder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;



 /**
 * 水印分配流程
 * <pre> 
 * 描述：水印分配流程 实体对象
 * 构建组：x7
 * 作者:zjq
 * 邮箱:zjq@jee-soft.cn
 * 日期:2020-12-23 17:12:58
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
 @TableName("bpm_watermark_process")
 @ApiModel(value = "BpmWatermarkProcess",description = "水印分配流程") 
public class BpmWatermarkProcess extends BaseModel<BpmWatermarkProcess>{

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="ID")
	protected String id; 
	
	@XmlAttribute(name = "procDefId")
	@TableField("PROC_DEF_ID_")
	@ApiModelProperty(value="流程ID")
	protected String procDefId; 
	
	@XmlAttribute(name = "procDefKey")
	@TableField("PROC_DEF_KEY_")
	@ApiModelProperty(value="流程Key")
	protected String procDefKey; 
	
	@XmlAttribute(name = "procDefName")
	@TableField("PROC_DEF_NAME_")
	@ApiModelProperty(value="流程名称")
	protected String procDefName; 
	
	@XmlAttribute(name = "watermarkId")
	@TableField("WATERMARK_ID_")
	@ApiModelProperty(value="水印ID")
	protected String watermarkId; 
	
	@XmlAttribute(name = "tenantId")
	@TableField("TENANT_ID_")
	@ApiModelProperty(value="租户ID")
	protected String tenantId; 
	
	
	public void setId(String id) {
		this.id = id;
	}
	
	/**
	 * 返回 ID
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}
	
	/**
	 * 返回 流程ID
	 * @return
	 */
	public String getProcDefId() {
		return this.procDefId;
	}
	public void setProcDefKey(String procDefKey) {
		this.procDefKey = procDefKey;
	}
	
	/**
	 * 返回 流程Key
	 * @return
	 */
	public String getProcDefKey() {
		return this.procDefKey;
	}
	public void setProcDefName(String procDefName) {
		this.procDefName = procDefName;
	}
	
	/**
	 * 返回 流程名称
	 * @return
	 */
	public String getProcDefName() {
		return this.procDefName;
	}
	public void setWatermarkId(String watermarkId) {
		this.watermarkId = watermarkId;
	}
	
	/**
	 * 返回 水印ID
	 * @return
	 */
	public String getWatermarkId() {
		return this.watermarkId;
	}
	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}
	
	/**
	 * 返回 租户ID
	 * @return
	 */
	public String getTenantId() {
		return this.tenantId;
	}
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("procDefId", this.procDefId) 
		.append("procDefKey", this.procDefKey) 
		.append("procDefName", this.procDefName) 
		.append("watermarkId", this.watermarkId) 
		.append("tenantId", this.tenantId) 
		.toString();
	}
}