package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.dao.BpmSaveOpinionDao;
import com.artfess.bpm.persistence.manager.BpmSaveOpinionManager;
import com.artfess.bpm.persistence.model.BpmSaveOpinion;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 *  审批意见暂存表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2020-08-24
 */
@Service
public class BpmSaveOpinionManagerImpl extends BaseManagerImpl<BpmSaveOpinionDao, BpmSaveOpinion> implements BpmSaveOpinionManager {

    @Override
    public BpmSaveOpinion getBpmSaveOpinionByTeam(Map<String, Object> params) {
        return baseMapper.getBpmSaveOpinionByTeam(params);
    }

    @Override
    @Transactional
    public void updateBpmSaveOpinionByTeam(Map<String, Object> params) {
        baseMapper.updateBpmSaveOpinionByTeam(params);
    }

    @Override
    @Transactional
    public Boolean createBpmSaveOpinion(BpmSaveOpinion bpmSaveOpinion) {
        if(BeanUtils.isNotEmpty(bpmSaveOpinion) &&
                StringUtil.isNotEmpty(bpmSaveOpinion.getProcInstId()) && StringUtil.isNotEmpty(bpmSaveOpinion.getTaskId())){
            //通过流程实例ID获取审批意见
            Map<String, Object> params = new HashMap<>();
            params.put("instId", bpmSaveOpinion.getProcInstId());
            params.put("taskId", bpmSaveOpinion.getTaskId());
            BpmSaveOpinion entity = baseMapper.getBpmSaveOpinionByTeam(params);
            //通过流程实例ID修改审批意见
            if(BeanUtils.isNotEmpty(entity)){//修改
                params.put("opinion", bpmSaveOpinion.getOpinion());
                baseMapper.updateBpmSaveOpinionByTeam(params);
                return true;
            }else{//新增
                baseMapper.insert(bpmSaveOpinion);
                return true;
            }
        }
        return false;
    }
}
