import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/queryByUser`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 查询企业列表
export function dataEnterpriseList(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizEnterprise/v1/query`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 获取考核配置分页
export function getEvaluationConfig(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post('/bizSupplierPerformanceEvaluationConfiguration/v1/query',data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}
// 表格考核配置详情
export function getEvaluationConfigDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluationConfiguration/v1/getModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
// 表格新增
export function dataAdd(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/userRating`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 表格详情
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierPerformanceEvaluation/v1/getUserModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

        
// 表格修改
export function dataUpdate(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierPerformanceEvaluation/v1/updateModel`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}


// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
