package com.artfess.bo.persistence.dao;

import com.artfess.bo.model.BoEntRel;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 实体关系
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月13日
 */
public interface BoEntRelDao extends BaseMapper<BoEntRel> {
    /**
     * 通过defId和entId查询数据
     *
     * @param defId
     * @return
     */
    List<BoEntRel> getByDefIdAndEntId(@Param("defId") String defId, @Param("entId") String entId);

    /**
     * 根据BO定义ID获取BO实体列表。
     *
     * @param defId
     * @return
     */
    List<BoEntRel> getByDefId(String defId);

    /**
     * 通过bo定义ID删除实体关系
     *
     * @param defId bo定义ID
     */
    void removeByDefId(String defId);

    /**
     * 通过实体ID查询实体关系
     *
     * @param entId 实体ID
     * @return
     */
    List<BoEntRel> getByEntId(String entId);
}
