package com.artfess.examine.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *  题目选项信息
 *
 * @author min.wu
 * @date 2020-10-22 10:18:03
 */
@Data
public class QuestionOptionReqVo implements Serializable {
    private static final long serialVersionUID = -38454803476169341L;

    @ApiModelProperty(value = "问题ID")
    private String questionId;

    @ApiModelProperty(value = "答题结果")
    private String result;

    @ApiModelProperty(value = "正确答案")
    private String rightOption;

    @ApiModelProperty(value = "是否正确【字典】（0：否，1：是）")
    private String isRight;

    @ApiModelProperty(value = "试题难度【字典】(1：简单，2：普通，3：困难)")
    private String difficulty;

    @ApiModelProperty(value = "实际得分")
    private BigDecimal actualScore;


}
