package com.artfess.examine.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.util.List;

/**
 * 题库试题信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamQuestionsInfo对象", description="题库试题信息")
public class ExamQuestionsInfo extends AutoFillModel<ExamQuestionsInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "岗位名称", column = "B")
    @ApiModelProperty(value = "岗位名称")
    @TableField(exist = false)
    private String positionName;

    @Excel(name = "题型", column = "C")
    @NotBlank(message = "请选择试题题型",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "试题题型【字典】（1：单选，2：多选，3：判断，4：填空，5：简答，6：操作,7:论述题）")
    @TableField("type_")
    private String type;

    @Excel(name = "题目", column = "D")
    @NotBlank(message = "请填写试题标题",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "试题标题")
    @TableField("question_")
    private String question;

    @ApiModelProperty(value = "试题分组标识")
    @TableField("group_flag_")
    private String groupFlag;

    @Excel(name = "答案", column = "K")
    @ApiModelProperty(value = "正确答案")
    @TableField("right_option_")
    private String rightOption;

    @ApiModelProperty(value = "试题难度【字典】(1：简单，2：普通，3：困难)")
    @TableField("difficulty_")
    private String difficulty;

    @NotBlank(message = "请选择科目",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "科目id")
    @TableField("sub_id_")
    private String subId;


    @ApiModelProperty(value = "题目分数")
    @TableField("score_")
    private BigDecimal score;

    @Excel(name = "题目解析", column = "L")
    @ApiModelProperty(value = "题目解析")
    @TableField("parsing_")
    private String parsing;

    @ApiModelProperty(value = "评卷方式【字典】（1：系统，2：人工）")
    @TableField("mark_type_")
    private String markType;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照题型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "问题选项信息")
    @TableField(exist = false)
    private List<ExamQuestionsOption> options;

    @ApiModelProperty(value = "课目")
    @TableField(exist = false)
    private String subjectName;

    @Excel(name = "答案选择1", column = "E")
    @ApiModelProperty(value = "答案选择1")
    @TableField(exist = false)
    private String optionOne;

    @Excel(name = "答案选择2", column = "F")
    @ApiModelProperty(value = "答案选择2")
    @TableField(exist = false)
    private String optionTwo;

    @Excel(name = "答案选择3", column = "G")
    @ApiModelProperty(value = "答案选择3")
    @TableField(exist = false)
    private String optionThree;

    @Excel(name = "答案选择4", column = "H")
    @ApiModelProperty(value = "答案选择4")
    @TableField(exist = false)
    private String optionFour;

    @Excel(name = "答案选择5", column = "I")
    @ApiModelProperty(value = "答案选择5")
    @TableField(exist = false)
    private String optionFive;

    @Excel(name = "答案选择6", column = "J")
    @ApiModelProperty(value = "答案选择6")
    @TableField(exist = false)
    private String optionSix;

    @ApiModelProperty(value = "专业装备")
    @TableField(exist = false)
    private String majorName;

}
