package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 用户通知公告中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@ApiModel(value="ExamNoticeUser对象", description="用户通知公告中间表")
public class ExamNoticeUser extends BaseModel<ExamNoticeUser> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "通知公告ID")
    @TableField("notice_id_")
    private String noticeId;

    @ApiModelProperty(value = "通知对象类型（1：所有人  2：组织 3：用户）")
    @TableField("object_type_")
    private String objectType;

    @ApiModelProperty(value = "通知对象ID(用户ID或组织ID)")
    @TableField("access_control_id_")
    private String accessControlId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }

    public String getObjectType() {
        return objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getAccessControlId() {
        return accessControlId;
    }

    public void setAccessControlId(String accessControlId) {
        this.accessControlId = accessControlId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ExamNoticeUser{" +
            "id=" + id +
            ", noticeId=" + noticeId +
            ", objectType=" + objectType +
            ", accessControlId=" + accessControlId +
        "}";
    }
}
