package com.artfess.data.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DictionaryUtils;
import com.artfess.data.dao.BizExamSpaceDataDao;
import com.artfess.data.manager.BizEquipmentBaseDataManager;
import com.artfess.data.manager.BizExamIndexDataManager;
import com.artfess.data.manager.BizExamSpaceDataManager;
import com.artfess.data.manager.BizTrainEquipmentDataManager;
import com.artfess.data.model.BizExamSpaceData;
import com.artfess.data.vo.TrainReqVo;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 训练场地数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizExamSpaceDataManagerImpl extends BaseManagerImpl<BizExamSpaceDataDao, BizExamSpaceData> implements BizExamSpaceDataManager {

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Autowired
    private BizExamIndexDataManager indexDataManager;

    @Autowired
    private BizTrainEquipmentDataManager trainEquipmentDataManager;

    @Autowired
    private BizEquipmentBaseDataManager equipmentBaseDataManager;

    @Override
    public void saveList(List<BizExamSpaceData> list) {
        List<OrgVo> orgVos = orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText(data.getName(), "请填写场地名称");
            if(null != DictionaryUtils.getDictInfo("cdlx", data.getType())) {
                String type = DictionaryUtils.getDictInfo("cdlx", data.getType()).getValue();
                data.setType(type);
            }
            if (!CollectionUtils.isEmpty(orgMap) && null != orgMap.get(data.getAccountabilityOrg())) {
                data.setOrgId(orgMap.get(data.getAccountabilityOrg()).getId());
            }
        });

        this.saveBatch(list);
    }

    @Override
    public JSONObject trainSafeguard() {
        LambdaQueryWrapper<BizExamSpaceData> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(BizExamSpaceData::getIsDele, DelStatusEnum.N.getType());
        Integer spaceCount = baseMapper.selectCount(lambdaQueryWrapper);


        return null;
    }

    @Override
    public List<JSONObject> spacePancake(TrainReqVo reqVo) {
        return this.baseMapper.spacePancake(reqVo);
    }
}
