package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 试卷试题信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@ApiModel(value="ExamPaperInfo对象", description="试卷试题信息")
public class ExamPaperInfo extends BaseModel<ExamPaperInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷基础信息ID")
    @TableField("paper_base_id_")
    private String paperBaseId;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "单选题ID集合 以英文逗号隔开")
    @TableField("scq_ids_")
    private String scqIds;

    @ApiModelProperty(value = "多选题ID集合 以英文逗号隔开")
    @TableField("mcq_ids_")
    private String mcqIds;

    @ApiModelProperty(value = "判断题ID集合 以英文逗号隔开")
    @TableField("tof_ids_")
    private String tofIds;

    @ApiModelProperty(value = "填空题ID集合 以英文逗号隔开")
    @TableField("fill_ids_")
    private String fillIds;

    @ApiModelProperty(value = "简单题ID集合 以英文逗号隔开")
    @TableField("essay_ids_")
    private String essayIds;

    @ApiModelProperty(value = "操作题ID集合 以英文逗号隔开")
    @TableField("operation_ids_")
    private String operationIds;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPaperBaseId() {
        return paperBaseId;
    }

    public void setPaperBaseId(String paperBaseId) {
        this.paperBaseId = paperBaseId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getScqIds() {
        return scqIds;
    }

    public void setScqIds(String scqIds) {
        this.scqIds = scqIds;
    }

    public String getMcqIds() {
        return mcqIds;
    }

    public void setMcqIds(String mcqIds) {
        this.mcqIds = mcqIds;
    }

    public String getTofIds() {
        return tofIds;
    }

    public void setTofIds(String tofIds) {
        this.tofIds = tofIds;
    }

    public String getFillIds() {
        return fillIds;
    }

    public void setFillIds(String fillIds) {
        this.fillIds = fillIds;
    }

    public String getEssayIds() {
        return essayIds;
    }

    public void setEssayIds(String essayIds) {
        this.essayIds = essayIds;
    }

    public String getOperationIds() {
        return operationIds;
    }

    public void setOperationIds(String operationIds) {
        this.operationIds = operationIds;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "ExamPaperInfo{" +
            "id=" + id +
            ", paperBaseId=" + paperBaseId +
            ", userId=" + userId +
            ", scqIds=" + scqIds +
            ", mcqIds=" + mcqIds +
            ", tofIds=" + tofIds +
            ", fillIds=" + fillIds +
            ", essayIds=" + essayIds +
            ", operationIds=" + operationIds +
            ", memo=" + memo +
        "}";
    }
}
