package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.vo.ArchivesManagerVo;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.manager.ExamUserEvaluationDetailManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * 档案管理
 *
 * @Author : min.wu
 * @Date: 2024/09/04 17:39
 */
@Slf4j
@RestController
@Api(tags = "训练数据-档案管理")
@RequestMapping("/biz/archives/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ArchivesManagerController {

    @Autowired
    private ExamUserEvaluationManager userEvaluationManager;

    @Autowired
    private ExamUserEvaluationDetailManager userEvaluationDetailManager;


    @PostMapping(value = "/personArchives", produces = {"application/json; charset=utf-8"})
    @ApiOperation("个人档案")
    public PageList<ExamUserEvaluationDetail> personArchives(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        return userEvaluationDetailManager.findByPage(queryFilter);
    }

    @PostMapping(value = "/positionArchives", produces = {"application/json; charset=utf-8"})
    @ApiOperation("岗位档案")
    public PageList<ArchivesManagerVo> positionArchives(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return userEvaluationManager.positionArchives(queryFilter);
    }

    @PostMapping(value = "/orgArchives", produces = {"application/json; charset=utf-8"})
    @ApiOperation("单位档案")
    public PageList<ArchivesManagerVo> orgArchives(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return userEvaluationManager.orgArchives(queryFilter);
    }

    @PostMapping(value = "/subjectArchives", produces = {"application/json; charset=utf-8"})
    @ApiOperation("课目档案")
    public PageList<ArchivesManagerVo> subjectArchives(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return userEvaluationManager.subjectArchives(queryFilter);
    }

    @PostMapping(value = "/subjectArchives/exportWord", produces = {"application/json; charset=utf-8"})
    @ApiOperation("导出课目档案")
    public void subjectArchivesExport(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter
            , HttpServletResponse response) {
        userEvaluationManager.subjectArchivesExport(queryFilter, response);
    }

    @PostMapping(value = "/orgArchives/exportWord", produces = {"application/json; charset=utf-8"})
    @ApiOperation("导出单位档案")
    public void orgArchivesExport(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter
            , HttpServletResponse response) {
        userEvaluationManager.orgArchivesExport(queryFilter, response);
    }

    @PostMapping(value = "/positionArchives/exportWord", produces = {"application/json; charset=utf-8"})
    @ApiOperation("导出岗位档案")
    public void positionArchivesExport(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter
            , HttpServletResponse response) {
        userEvaluationManager.positionArchivesExport(queryFilter, response);
    }

    @PostMapping(value = "/personArchives/exportWord", produces = {"application/json; charset=utf-8"})
    @ApiOperation("导出个人档案")
    public void personArchivesExport(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter
            , HttpServletResponse response) {
        userEvaluationDetailManager.personArchivesExport(queryFilter, response);
    }


    @PostMapping(value = "/userStudyAnalyse", produces = {"application/json; charset=utf-8"})
    @ApiOperation("人员学习情况分析")
    public PageList<UserExamVo> userStudyAnalyse(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        return userEvaluationDetailManager.userStudyAnalyse(queryFilter);
    }

    /**
     * 人员考试成绩和年度考核成绩合并 为一个
     * @param queryFilter
     * @return
     */
//    @PostMapping(value = "/userExamAnalyse", produces = {"application/json; charset=utf-8"})
//    @ApiOperation("人员考试成绩分析")
//    public PageList<UserExamVo> userExamAnalyse(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter) {
//        return userEvaluationDetailManager.userExamAnalyse(queryFilter);
//    }

}
