/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.artfess.poi.Excel;
import com.artfess.poi.HeaderNode;
import com.artfess.poi.util.ExcelUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHeader {
    private static final Logger log = LoggerFactory.getLogger(CustomHeader.class);

    public static void export(List<HeaderNode> headerNodes, HttpServletResponse response, String fileName) throws IOException {
        Excel excel = new Excel();
        excel.sheet().sheetName("\u5e74\u5ea6\u6210\u7ee9\u4fe1\u606f");
        HSSFWorkbook workbook = excel.getWorkBook();
        HSSFSheet sheet = workbook.getSheet("\u5e74\u5ea6\u6210\u7ee9\u4fe1\u606f");
        HSSFCellStyle headStyle = workbook.createCellStyle();
        CustomHeader.defaultHeadStyle((CellStyle)headStyle);
        int deep = headerNodes.stream().map(HeaderNode::getRow).reduce(Integer::max).orElse(1);
        for (int i = 0; i <= 3; ++i) {
            sheet.createRow(i);
        }
        for (HeaderNode headerNode : headerNodes) {
            int row = headerNode.getRow();
            if (row <= 3) {
                int col = headerNode.getColumn();
                excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName()).style(headStyle);
                CellRangeAddress region = headerNode.isOverNode() ? new CellRangeAddress(row, 3, col, col) : new CellRangeAddress(row, row, col, col + headerNode.getOverNodeCount() - 1);
                if (region.getNumberOfCells() <= 1) continue;
                sheet.addMergedRegionUnsafe(region);
                RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                continue;
            }
            excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName());
        }
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String customizeLabel = "[{\"headerName\":\"\u673a\u6784\u540d\u79f0\",\"column\":0,\"row\":0},{\"headerName\":\"\u5361\u7c7b\u578b\u4ee3\u7801\",\"column\":1,\"row\":0},{\"headerName\":\"\u5361\u7c7b\u578b\u540d\u79f0\",\"column\":2,\"row\":0},{\"headerName\":\"\u671f\u521d\u5e93\u5b58\u91cf\",\"column\":3,\"row\":0},{\"headerName\":\"\u672c\u671f\u5165\u5e93\u60c5\u51b5\",\"column\":4,\"row\":0,\"overNodeCount\":4,\"overNode\":false},{\"headerName\":\"\u672c\u671f\u5165\u5e93\u5c0f\u8ba1\",\"column\":4,\"row\":1},{\"headerName\":\"\u672c\u671f\u5165\u5e93\u660e\u7ec6\",\"column\":5,\"row\":\"1\",\"overNodeCount\":3,\"overNode\":false},{\"headerName\":\"\u5370\u5237\u5165\u5e93\",\"column\":5,\"row\":2},{\"headerName\":\"\u9886\u7528\u5165\u5e93\",\"column\":6,\"row\":2},{\"headerName\":\"\u56de\u6536\u5165\u5e93\",\"column\":7,\"row\":2},{\"headerName\":\"\u672c\u671f\u51fa\u5e93\u60c5\u51b5\",\"column\":8,\"row\":0,\"overNodeCount\":7,\"overNode\":false},{\"headerName\":\"\u672c\u671f\u51fa\u5e93\u5c0f\u8ba1\",\"column\":8,\"row\":\"1\"},{\"headerName\":\"\u672c\u671f\u51fa\u5e93\u660e\u7ec6\",\"column\":9,\"row\":\"1\",\"overNodeCount\":6,\"overNode\":false},{\"headerName\":\"\u673a\u6784/\u90e8\u95e8\u4e0b\u53d1\u51fa\u5e93\",\"column\":9,\"row\":2},{\"headerName\":\"\u5458\u5de5\u4e0b\u53d1\u51fa\u5e93\",\"column\":10,\"row\":2},{\"headerName\":\"\u56de\u6536\u63d0\u4ea4\u51fa\u5e93\",\"column\":11,\"row\":2},{\"headerName\":\"\u6e05\u7406\u51fa\u5e93\",\"column\":12,\"row\":2},{\"headerName\":\"\u9500\u6bc1\u51fa\u5e93\",\"column\":13,\"row\":2},{\"headerName\":\"\u5176\u4ed6\u65b9\u5f0f\u51fa\u5e93\",\"column\":14,\"row\":2},{\"headerName\":\"\u5269\u4f59\u5e93\u5b58\u91cf\",\"column\":15,\"row\":0}]";
        List headerNodes = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)customizeLabel), HeaderNode.class);
        SXSSFWorkbook book = new SXSSFWorkbook();
        SXSSFSheet sxssfSheet = book.createSheet("\u6d4b\u8bd5");
        CellStyle headStyle = book.createCellStyle();
        CustomHeader.defaultHeadStyle(headStyle);
        int deep = headerNodes.stream().map(HeaderNode::getRow).reduce(Integer::max).orElse(1);
        for (int i = 0; i < deep; ++i) {
            sxssfSheet.createRow(i);
        }
        for (HeaderNode headerNode : headerNodes) {
            int row = headerNode.getRow();
            int col = headerNode.getColumn();
            SXSSFCell sxssfCell = sxssfSheet.getRow(row).createCell(col);
            sxssfSheet.setColumnWidth(col, headerNode.getWidth() * 256);
            sxssfCell.setCellStyle(headStyle);
            sxssfCell.setCellValue(headerNode.getHeaderName());
            CellRangeAddress region = headerNode.isOverNode() ? new CellRangeAddress(row, deep, col, col) : new CellRangeAddress(row, row, col, col + headerNode.getOverNodeCount() - 1);
            if (region.getNumberOfCells() <= 1) continue;
            sxssfSheet.addMergedRegionUnsafe(region);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sxssfSheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sxssfSheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sxssfSheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sxssfSheet);
        }
        FileOutputStream fileOut = null;
        try {
            File file = new File("D:/excel/myExcel.xls");
            fileOut = new FileOutputStream(file);
            book.write((OutputStream)fileOut);
            System.out.println("----Excle\u6587\u4ef6\u5df2\u751f\u6210------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void defaultHeadStyle(CellStyle headStyle) {
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
    }
}

