/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.examine.manager.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.constants.CodePrefix;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.enums.PaperStatusEnum;
import com.artfess.base.enums.PaperTypeEnum;
import com.artfess.base.enums.QuestionStateEnum;
import com.artfess.base.enums.QuestionTypeEnum;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.enums.ScoreLevelEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.examine.dao.ExamPaperBaseDao;
import com.artfess.examine.dao.ExamQuestionsInfoDao;
import com.artfess.examine.dao.ExamQuestionsOptionDao;
import com.artfess.examine.dao.ExamSubjectInfoDao;
import com.artfess.examine.dao.ExamUserRecordDao;
import com.artfess.examine.dao.ExamYearReportDao;
import com.artfess.examine.manager.ExamPaperSettingManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.manager.ExamUserRecordDetailManager;
import com.artfess.examine.manager.ExamUserRecordManager;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamPaperSetting;
import com.artfess.examine.model.ExamQuestionsOption;
import com.artfess.examine.model.ExamUserRecord;
import com.artfess.examine.model.ExamUserRecordDetail;
import com.artfess.examine.vo.ApplyPaperReqVo;
import com.artfess.examine.vo.ExamReqVo;
import com.artfess.examine.vo.JobStatisticalVo;
import com.artfess.examine.vo.MyExamInfoVo;
import com.artfess.examine.vo.PaperAnalysisVo;
import com.artfess.examine.vo.PaperStatisticalVo;
import com.artfess.examine.vo.QuestionOptionReqVo;
import com.artfess.examine.vo.QuestionsInfoVo;
import com.artfess.examine.vo.SubjectQuestionTypeVo;
import com.artfess.examine.vo.SubmitAnswerReqVo;
import com.artfess.examine.vo.UserInfoVo;
import com.artfess.examine.vo.YearSubjectScoreVO;
import com.artfess.redis.util.RedisUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ExamUserRecordManagerImpl
extends BaseManagerImpl<ExamUserRecordDao, ExamUserRecord>
implements ExamUserRecordManager {
    private static final Logger log = LoggerFactory.getLogger(ExamUserRecordManagerImpl.class);
    @Autowired
    private ExamUserRecordDetailManager userRecordDetailManager;
    @Autowired
    private ExamPaperSettingManager paperSettingManager;
    @Autowired
    private ExamUserRecordManager userRecordManager;
    @Resource
    private ExamQuestionsOptionDao questionsOptionDao;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private ExamPaperBaseDao paperBaseDao;
    @Resource
    private ExamQuestionsInfoDao questionsInfoDao;
    @Resource
    private ExamSubjectInfoDao subjectInfoDao;
    @Resource
    private ExamUserEvaluationManager userEvaluationManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;
    @Resource
    private ExamYearReportDao yearReportDao;

    @Override
    public List<QuestionsInfoVo> getQuestionList(ExamReqVo reqVo) {
        return ((ExamUserRecordDao)this.baseMapper).getQuestionList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveScore(SubmitAnswerReqVo reqVo) {
        Assert.hasText((String)reqVo.getRecordId(), (String)"\u7b54\u9898\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        ExamUserRecord userRecord = (ExamUserRecord)((Object)((ExamUserRecordDao)this.baseMapper).selectById((Serializable)((Object)reqVo.getRecordId())));
        ArrayList detailList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(reqVo.getQuestionOptionList())) {
            BigDecimal totalScore = BigDecimal.ZERO;
            for (QuestionOptionReqVo option : reqVo.getQuestionOptionList()) {
                if (null == option.getActualScore()) continue;
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"record_id_", (Object)reqVo.getRecordId());
                queryWrapper.eq((Object)"question_id_", (Object)option.getQuestionId());
                ExamUserRecordDetail userRecordDetail = (ExamUserRecordDetail)((Object)this.userRecordDetailManager.getBaseMapper().selectOne((Wrapper)queryWrapper));
                if (null == userRecordDetail) continue;
                if (QuestionTypeEnum.fillIn.getType().equals(userRecordDetail.getQuestionType()) || QuestionTypeEnum.shortAnswer.getType().equals(userRecordDetail.getQuestionType()) || QuestionTypeEnum.operation.getType().equals(userRecordDetail.getQuestionType()) || QuestionTypeEnum.lst.getType().equals(userRecordDetail.getQuestionType())) {
                    if (null == userRecordDetail.getActualScore()) {
                        userRecordDetail.setActualScore(BigDecimal.ZERO);
                    }
                    if (StringUtils.isEmpty((Object)userRecordDetail.getResult()) && option.getActualScore().longValue() > 0L) {
                        throw new BaseException("\u9898\u76ee\u672a\u586b\u5199\u5185\u5bb9\u5206\u6570\u4e0d\u80fd\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u8bc4\u5377\u5206\u6570\u3002");
                    }
                    BigDecimal actualScore = BigDecimal.ZERO;
                    if (null != option.getActualScore()) {
                        actualScore = option.getActualScore();
                    }
                    if (actualScore.longValue() == userRecordDetail.getScore().longValue()) {
                        userRecordDetail.setIsRight("1");
                    } else if (actualScore.longValue() < userRecordDetail.getScore().longValue()) {
                        userRecordDetail.setIsRight("2");
                    } else if (actualScore.longValue() == 0L) {
                        userRecordDetail.setIsRight("0");
                    }
                    userRecordDetail.setActualScore(actualScore);
                    totalScore = totalScore.add(option.getActualScore());
                    detailList.add(userRecordDetail);
                    continue;
                }
                totalScore = totalScore.add(userRecordDetail.getActualScore());
            }
            userRecord.setSysScore(totalScore);
        }
        userRecord.setLevel(ScoreLevelEnum.getLevel((BigDecimal)userRecord.getSysScore()));
        userRecord.setMarkTime(LocalDateTime.now());
        userRecord.setMarkUser(AuthenticationUtil.getCurrentUsername());
        userRecord.setStatus(QuestionStateEnum.finish.getType());
        int i = ((ExamUserRecordDao)this.baseMapper).updateById((Object)userRecord);
        if (i > 0) {
            this.userRecordDetailManager.updateBatchById(detailList);
            this.executorService.execute(() -> {
                try {
                    this.userEvaluationManager.userEvaluation(userRecord);
                }
                catch (Exception e) {
                    log.error("\u8003\u751f\u5e74\u5ea6\u7efc\u5408\u8bc4\u5b9a\u5931\u8d25:{}", (Throwable)e);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MyExamInfoVo startExam(ExamReqVo reqVo) {
        Assert.hasText((String)reqVo.getRecordId(), (String)"\u8003\u8bd5\u8bd5\u5377id\u4e0d\u80fd\u4e3a\u7a7a");
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getById((Serializable)((Object)reqVo.getRecordId())));
        if (!examUserRecord.getUserId().equals(reqVo.getUserId())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u53d1\u751f\u9519\u8bef\uff01");
        }
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)examUserRecord.getPaperId());
        ExamPaperSetting paperSetting = (ExamPaperSetting)((Object)this.paperSettingManager.getOne((Wrapper)queryWrapper));
        boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)paperSetting.getPlanStartTime());
        if (dateEquals) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u8fd8\u672a\u5f00\u59cb");
        }
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)this.paperBaseDao.selectById((Serializable)((Object)examUserRecord.getPaperId())));
        if (null == examPaperBase) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u5df2\u5220\u9664\uff0c\u4e0d\u80fd\u8fdb\u884c\u8003\u8bd5");
        }
        if (QuestionStateEnum.haveTest.getType().equals(examUserRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u60a8\u5df2\u4ea4\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.finish.getType().equals(examUserRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u5df2\u9605\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.zuobi.getType().equals(examUserRecord.getStatus())) {
            throw new RuntimeException("\u8003\u8bd5\u4e2d\u6709\u4f5c\u5f0a\u884c\u4e3a\uff0c\u5df2\u88ab\u5f3a\u5236\u4ea4\u5377");
        }
        MyExamInfoVo myExamInfoVo = new MyExamInfoVo();
        BeanUtils.copyProperties((Object)((Object)examUserRecord), (Object)myExamInfoVo);
        myExamInfoVo.setTotalNumber(examPaperBase.getTotalNumber());
        myExamInfoVo.setTotalScore(examPaperBase.getTotalScore());
        if (null == examUserRecord.getSwitchCount()) {
            myExamInfoVo.setInSwitchCount(0);
        } else {
            myExamInfoVo.setInSwitchCount(examUserRecord.getSwitchCount());
        }
        myExamInfoVo.setSwitchCount(paperSetting.getSwitchCount());
        reqVo.setRecordId(examUserRecord.getId());
        BigDecimal totalTime = paperSetting.getTimeLength().multiply(new BigDecimal(60)).multiply(new BigDecimal(1000));
        if (QuestionStateEnum.inTest.getType().equals(examUserRecord.getStatus())) {
            this.getBalanceAwswerTime(reqVo);
            Long useTime = System.currentTimeMillis() - myExamInfoVo.getStartTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
            myExamInfoVo.setTimeLength(totalTime.subtract(new BigDecimal(useTime)));
        } else {
            examUserRecord.setStatus(QuestionStateEnum.inTest.getType());
            examUserRecord.setStartTime(LocalDateTime.now());
            myExamInfoVo.setTimeLength(totalTime);
            this.createUserTask(reqVo, paperSetting.getTimeLength());
        }
        this.userRecordManager.updateById((Object)examUserRecord);
        List<QuestionsInfoVo> questionList = this.userRecordManager.getQuestionList(reqVo);
        if (CollectionUtils.isEmpty(questionList)) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u6c92\u6709\u9898\u76ee\u4fe1\u606f");
        }
        List questionIds = questionList.stream().map(QuestionsInfoVo::getQuestionId).collect(Collectors.toList());
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            question.setRightOption(null);
            if (!map.containsKey(question.getQuestionId())) {
                return;
            }
            question.setOptions((List)map.get(question.getQuestionId()));
        });
        myExamInfoVo.setQuestionsInfoVos(questionList);
        myExamInfoVo.setRecordId(examUserRecord.getId());
        return myExamInfoVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitAnswer(SubmitAnswerReqVo reqVo) {
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getBaseMapper().selectById((Serializable)((Object)reqVo.getRecordId())));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)examUserRecord.getPaperId());
        ExamPaperSetting paperSetting = (ExamPaperSetting)((Object)this.paperSettingManager.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)paperSetting), (String)"\u8003\u8bd5\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (QuestionStateEnum.haveTest.getType().equals(examUserRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u60a8\u5df2\u4ea4\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.finish.getType().equals(examUserRecord.getStatus())) {
            throw new RuntimeException("\u5f53\u524d\u8bd5\u5377\u5df2\u9605\u5377\uff0c\u4e0d\u80fd\u518d\u6b21\u8003\u8bd5");
        }
        if (QuestionStateEnum.zuobi.getType().equals(examUserRecord.getStatus())) {
            throw new RuntimeException("\u8003\u8bd5\u4e2d\u6709\u4f5c\u5f0a\u884c\u4e3a\uff0c\u5df2\u88ab\u5f3a\u5236\u4ea4\u5377");
        }
        boolean b = DateUtil.belongCalendar((LocalDateTime)LocalDateTime.now(), (LocalDateTime)paperSetting.getPlanStartTime(), (LocalDateTime)paperSetting.getPlanEndTime());
        if (!b && paperSetting.getStatus().equals("2")) {
            throw new RuntimeException("\u8003\u8bd5\u4efb\u52a1\u5df2\u7ed3\u675f");
        }
        List<QuestionOptionReqVo> options = reqVo.getQuestionOptionList();
        HashMap userOptionNumber = Maps.newHashMap();
        options.forEach(option -> {
            if (userOptionNumber.containsKey(option.getQuestionId())) {
                userOptionNumber.put(option.getQuestionId(), (String)userOptionNumber.get(option.getQuestionId()) + "," + option.getResult());
            } else {
                userOptionNumber.put(option.getQuestionId(), option.getResult());
            }
        });
        if (null != reqVo.getStatus() && reqVo.getStatus() == 1) {
            examUserRecord.setStatus(QuestionStateEnum.haveTest.getType());
            long time = System.currentTimeMillis() - examUserRecord.getStartTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
            String answerTime = formatter.format(time);
            examUserRecord.setAnswerTime(answerTime);
            examUserRecord.setEndTime(LocalDateTime.now());
            if (null != paperSetting.getTrainModel() && 1 == paperSetting.getTrainModel()) {
                examUserRecord.setStatus(QuestionStateEnum.finish.getType());
            }
        }
        this.calculateScore(userOptionNumber, examUserRecord);
    }

    @Override
    public List<UserInfoVo> findByPaperId(String paperId) {
        return ((ExamUserRecordDao)this.baseMapper).findByPaperId(paperId);
    }

    @Override
    public PageList<ExamUserRecord> myPaper(QueryFilter<ExamUserRecord> queryFilter) {
        String year = String.valueOf(LocalDateTime.now().getYear());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"year_", (Object)year);
        Integer count = this.yearReportDao.selectCount((Wrapper)queryWrapper);
        PageBean pageBean = queryFilter.getPageBean();
        AtomicReference paperStatus = new AtomicReference();
        queryFilter.getQuerys().forEach(queryField -> {
            if ("paperStatus".equals(queryField.getProperty())) {
                paperStatus.set(queryField.getValue() + "");
            }
        });
        if (PaperStatusEnum.notRelease.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("sp.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.GREAT, FieldRelation.AND);
        } else if (PaperStatusEnum.inTets.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("sp.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
            queryFilter.addFilter("sp.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        } else if (PaperStatusEnum.finish.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("sp.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
        }
        if (!StringUtils.isEmpty(paperStatus.get())) {
            queryFilter.getQuerys().removeIf(s -> "paperStatus".equals(s.getProperty()));
        }
        queryFilter.addFilter("b.is_dele_", (Object)DelStatusEnum.N.getType(), QueryOP.EQUAL);
        IPage<ExamUserRecord> result = ((ExamUserRecordDao)this.baseMapper).myPaper((IPage<ExamUserRecord>)this.convert2IPage(pageBean), (Wrapper<ExamUserRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(userRecord -> {
            boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)userRecord.getPlanEndTime());
            if (dateEquals) {
                userRecord.setPaperStatus(PaperStatusEnum.inTets.getType());
            } else {
                userRecord.setPaperStatus(PaperStatusEnum.finish.getType());
            }
            boolean dateLittle = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)userRecord.getPlanStartTime());
            if (dateLittle) {
                userRecord.setPaperStatus(PaperStatusEnum.notRelease.getType());
            }
            if (QuestionStateEnum.notTo.getType().equals(userRecord.getStatus()) && dateEquals) {
                userRecord.setStatus(QuestionStateEnum.toBeAnswer.getType());
            }
            if (count > 0) {
                userRecord.setReportStatus("1");
            } else {
                userRecord.setReportStatus("0");
            }
        });
        return new PageList(result);
    }

    @Override
    public MyExamInfoVo getUserRecord(String id) {
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ExamReqVo reqVo = new ExamReqVo();
        reqVo.setRecordId(id);
        List<QuestionsInfoVo> questionList = this.userRecordManager.getQuestionList(reqVo);
        if (CollectionUtils.isEmpty(questionList)) {
            return new MyExamInfoVo();
        }
        List questionIds = questionList.stream().map(QuestionsInfoVo::getQuestionId).collect(Collectors.toList());
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            if (StringUtils.isEmpty((Object)question.getResult())) {
                question.setActualScore(BigDecimal.ZERO);
            }
            if (!map.containsKey(question.getQuestionId())) {
                return;
            }
            question.setOptions((List)map.get(question.getQuestionId()));
        });
        MyExamInfoVo myExamInfoVo = new MyExamInfoVo();
        BeanUtils.copyProperties((Object)((Object)examUserRecord), (Object)myExamInfoVo);
        reqVo.setRecordId(examUserRecord.getId());
        myExamInfoVo.setQuestionsInfoVos(questionList);
        myExamInfoVo.setRecordId(examUserRecord.getId());
        return myExamInfoVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void switchCount(String id) {
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getBaseMapper().selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)examUserRecord.getPaperId());
        ExamPaperSetting paperSetting = (ExamPaperSetting)((Object)this.paperSettingManager.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)paperSetting), (String)"\u8003\u8bd5\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (null == paperSetting.getSwitchCount()) {
            return;
        }
        if (null == examUserRecord.getSwitchCount()) {
            examUserRecord.setSwitchCount(1);
        } else {
            examUserRecord.setSwitchCount(examUserRecord.getSwitchCount() + 1);
        }
        if (paperSetting.getSwitchCount() <= examUserRecord.getSwitchCount()) {
            throw new BaseException(ResponseErrorEnums.Compulsory_PAPER_EXCEPTION);
        }
        ((ExamUserRecordDao)this.baseMapper).updateById((Object)examUserRecord);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void applyExamPaper(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8bd5\u5377");
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getBaseMapper().selectById((Serializable)((Object)id)));
        examUserRecord.setStatus("6");
        examUserRecord.setApplyTime(LocalDateTime.now());
        ((ExamUserRecordDao)this.baseMapper).updateById((Object)examUserRecord);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean modifyStatus(ApplyPaperReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u8bf7\u9009\u62e9\u7533\u8bf7\u8bb0\u5f55");
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getBaseMapper().selectById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        if ("0" == reqVo.getStatus()) {
            examUserRecord.setStatus("8");
        } else {
            examUserRecord.setStatus("7");
        }
        int i = ((ExamUserRecordDao)this.baseMapper).updateById((Object)examUserRecord);
        return i > 0;
    }

    @Override
    public PageList<PaperStatisticalVo> paperStatistical(QueryFilter<ExamPaperBase> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PaperStatisticalVo> result = ((ExamUserRecordDao)this.baseMapper).paperStatistical((IPage<ExamUserRecord>)this.convert2IPage(pageBean), (Wrapper<ExamUserRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(paperStatisticalVo -> {
            paperStatisticalVo.setTotalNumber(paperStatisticalVo.getActualCount() + paperStatisticalVo.getLackCount());
            if (null == paperStatisticalVo.getPassCount() || 0.0 == paperStatisticalVo.getPassCount().doubleValue()) {
                paperStatisticalVo.setPassPercentage("0%");
            } else {
                BigDecimal multiply = paperStatisticalVo.getPassCount().divide(new BigDecimal(paperStatisticalVo.getTotalNumber()), 2, 4).multiply(new BigDecimal("100"));
                paperStatisticalVo.setPassPercentage(multiply + "%");
            }
            boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)paperStatisticalVo.getPlanEndTime());
            if (dateEquals) {
                paperStatisticalVo.setPaperStatus(PaperStatusEnum.inTets.getType());
            } else {
                paperStatisticalVo.setPaperStatus(PaperStatusEnum.finish.getType());
            }
            boolean dateLittle = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)paperStatisticalVo.getPlanStartTime());
            if (dateLittle) {
                paperStatisticalVo.setPaperStatus(PaperStatusEnum.notRelease.getType());
            }
            paperStatisticalVo.setAvgScore(new BigDecimal(paperStatisticalVo.getAvgScore()).setScale(2, RoundingMode.HALF_UP).toString());
        });
        return new PageList(result);
    }

    @Override
    public PaperAnalysisVo paperAnalysis() {
        QueryWrapper questionsInfoQueryWrapper = new QueryWrapper();
        questionsInfoQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        Integer questionCount = this.questionsInfoDao.selectCount((Wrapper)questionsInfoQueryWrapper);
        QueryWrapper paperBaseQueryWrapper = new QueryWrapper();
        paperBaseQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        paperBaseQueryWrapper.eq((Object)"type_", (Object)PaperTypeEnum.formal.getType());
        Integer paperCount = this.paperBaseDao.selectCount((Wrapper)paperBaseQueryWrapper);
        QueryWrapper subjectInfoQueryWrapper = new QueryWrapper();
        subjectInfoQueryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        Integer subjectCount = this.subjectInfoDao.selectCount((Wrapper)subjectInfoQueryWrapper);
        Integer userCount = ((ExamUserRecordDao)this.baseMapper).selectUserCount();
        List<SubjectQuestionTypeVo> questionTypeList = this.questionsInfoDao.selectTypeCount();
        PaperAnalysisVo paperAnalysisVo = new PaperAnalysisVo();
        paperAnalysisVo.setQuestionCount(questionCount);
        paperAnalysisVo.setPaperCount(paperCount);
        paperAnalysisVo.setSubjectCount(subjectCount);
        paperAnalysisVo.setUserCount(userCount);
        paperAnalysisVo.setQuestionTypeList(questionTypeList);
        List<JSONObject> difficulty = this.questionsInfoDao.selectDifficulty();
        paperAnalysisVo.setDifficulty(difficulty);
        return paperAnalysisVo;
    }

    @Override
    public JobStatisticalVo jobStatistical() {
        List<ExamUserRecord> records = ((ExamUserRecordDao)this.baseMapper).myUserRecord(AuthenticationUtil.getCurrentUserId());
        JobStatisticalVo jobStatisticalVo = new JobStatisticalVo();
        Integer recordCount = 0;
        Integer passCount = 0;
        Integer lackCount = 0;
        Integer zbCount = 0;
        for (ExamUserRecord userRecord : records) {
            boolean dateEquals;
            Integer n;
            boolean equals;
            Integer n2;
            if (QuestionStateEnum.ksStatusList().contains(userRecord.getStatus())) {
                Integer n3 = recordCount;
                n2 = recordCount = Integer.valueOf(recordCount + 1);
            }
            if (null != userRecord.getSysScore() && null != userRecord.getTotalNumber() && (equals = NumberUtil.equals((BigDecimal)userRecord.getTotalScore(), (BigDecimal)userRecord.getSysScore()))) {
                n2 = passCount;
                n = passCount = Integer.valueOf(passCount + 1);
            }
            if (!(dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)userRecord.getPlanEndTime())) && QuestionStateEnum.qkStatusList().contains(userRecord.getStatus())) {
                n2 = lackCount;
                n = lackCount = Integer.valueOf(lackCount + 1);
            }
            if (!QuestionStateEnum.zuobi.getType().equals(userRecord.getStatus())) continue;
            n2 = zbCount;
            n = zbCount = Integer.valueOf(zbCount + 1);
        }
        jobStatisticalVo.setRecordCount(recordCount);
        jobStatisticalVo.setLackCount(lackCount);
        jobStatisticalVo.setPassCount(passCount);
        jobStatisticalVo.setZbCount(zbCount);
        return jobStatisticalVo;
    }

    @Override
    public void updateStatus(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8003\u8bd5id");
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)((ExamUserRecordDao)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        examUserRecord.setStatus(QuestionStateEnum.zuobi.getType());
        ((ExamUserRecordDao)this.baseMapper).updateById((Object)examUserRecord);
    }

    @Override
    public PageList<ExamUserRecord> detailPage(QueryFilter<ExamUserRecord> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        AtomicReference paperStatus = new AtomicReference();
        queryFilter.getQuerys().forEach(queryField -> {
            if ("paperStatus".equals(queryField.getProperty())) {
                paperStatus.set(queryField.getValue() + "");
            }
        });
        if (PaperStatusEnum.notRelease.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("sp.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.GREAT, FieldRelation.AND);
        } else if (PaperStatusEnum.inTets.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("sp.plan_start_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
            queryFilter.addFilter("sp.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        } else if (PaperStatusEnum.finish.getType().equals(paperStatus.get())) {
            queryFilter.addFilter("sp.plan_end_time_", (Object)LocalDateTime.now(), QueryOP.LESS, FieldRelation.AND);
        }
        if (!StringUtils.isEmpty(paperStatus.get())) {
            queryFilter.getQuerys().removeIf(s -> "paperStatus".equals(s.getProperty()));
        }
        IPage<ExamUserRecord> result = ((ExamUserRecordDao)this.baseMapper).detailPage((IPage<ExamUserRecord>)this.convert2IPage(pageBean), (Wrapper<ExamUserRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        result.getRecords().forEach(userRecord -> {
            boolean dateEquals = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)userRecord.getPlanEndTime());
            if (dateEquals) {
                userRecord.setPaperStatus(PaperStatusEnum.inTets.getType());
            } else {
                userRecord.setPaperStatus(PaperStatusEnum.finish.getType());
            }
            boolean dateLittle = DateUtil.isDateLittle((LocalDateTime)LocalDateTime.now(), (LocalDateTime)userRecord.getPlanStartTime());
            if (dateLittle) {
                userRecord.setPaperStatus(PaperStatusEnum.notRelease.getType());
            }
            if (QuestionStateEnum.notTo.getType().equals(userRecord.getStatus()) && dateEquals) {
                userRecord.setStatus(QuestionStateEnum.toBeAnswer.getType());
            }
        });
        return new PageList(result);
    }

    @Override
    public MyExamInfoVo myPaperInfo(String id) {
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        ExamReqVo reqVo = new ExamReqVo();
        reqVo.setRecordId(id);
        List<QuestionsInfoVo> questionList = this.userRecordManager.getQuestionList(reqVo);
        if (CollectionUtils.isEmpty(questionList)) {
            return new MyExamInfoVo();
        }
        List questionIds = questionList.stream().map(QuestionsInfoVo::getQuestionId).collect(Collectors.toList());
        QueryWrapper optionQueryWrapper = new QueryWrapper();
        optionQueryWrapper.in((Object)"question_id_", questionIds);
        optionQueryWrapper.orderByAsc((Object)"option_key_");
        List examQuestionsOptions = this.questionsOptionDao.selectList((Wrapper)optionQueryWrapper);
        Map<String, List<ExamQuestionsOption>> map = examQuestionsOptions.stream().collect(Collectors.groupingBy(ExamQuestionsOption::getQuestionId));
        questionList.forEach(question -> {
            if (StringUtils.isEmpty((Object)question.getResult())) {
                question.setActualScore(BigDecimal.ZERO);
            }
            if (!map.containsKey(question.getQuestionId())) {
                return;
            }
            question.setOptions((List)map.get(question.getQuestionId()));
        });
        MyExamInfoVo myExamInfoVo = new MyExamInfoVo();
        BeanUtils.copyProperties((Object)((Object)examUserRecord), (Object)myExamInfoVo);
        reqVo.setRecordId(examUserRecord.getId());
        myExamInfoVo.setQuestionsInfoVos(questionList);
        myExamInfoVo.setRecordId(examUserRecord.getId());
        myExamInfoVo.setUserScore(examUserRecord.getSysScore());
        return myExamInfoVo;
    }

    @Override
    public List<YearSubjectScoreVO> getYearSubjectScore(String userId, Integer year) {
        return ((ExamUserRecordDao)this.baseMapper).getYearSubjectScoreByUserId(userId, year);
    }

    @Override
    public ExamPaperBase findByMyRecord(String id) {
        Assert.hasText((String)id, (String)"\u8bf7\u9009\u62e9\u8003\u8bd5id");
        ExamUserRecord examUserRecord = (ExamUserRecord)((Object)this.userRecordManager.getBaseMapper().selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)examUserRecord), (String)"\u8003\u8bd5\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"paper_id_", (Object)examUserRecord.getPaperId());
        ExamPaperSetting paperSetting = (ExamPaperSetting)((Object)this.paperSettingManager.getOne((Wrapper)queryWrapper));
        Assert.notNull((Object)((Object)paperSetting), (String)"\u8003\u8bd5\u4fe1\u606f\u4e0d\u5b58\u5728");
        ExamPaperBase examPaperBase = (ExamPaperBase)((Object)this.paperBaseDao.selectById((Serializable)((Object)examUserRecord.getPaperId())));
        if (null == examPaperBase) {
            return new ExamPaperBase();
        }
        examPaperBase.setPassScore(paperSetting.getPassScore());
        examPaperBase.setTimeLength(paperSetting.getTimeLength());
        return examPaperBase;
    }

    private void calculateScore(Map<String, String> userOptionNumber, ExamUserRecord record) {
        log.info("\u95ee\u9898\u9009\u9879\uff1a{}", userOptionNumber);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"record_id_", (Object)record.getId());
        List list = this.userRecordDetailManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        BigDecimal totalScore = BigDecimal.ZERO;
        for (ExamUserRecordDetail question : list) {
            String result = userOptionNumber.get(question.getQuestionId());
            question.setResult(result);
            if (!userOptionNumber.containsKey(question.getQuestionId())) continue;
            if (QuestionTypeEnum.multi.getType().equals(question.getQuestionType())) {
                Object[] split = result.split(",");
                Arrays.sort(split);
                result = String.join((CharSequence)",", (CharSequence[])split);
                Object[] rightKeys = question.getRightKey().split(",");
                Arrays.sort(rightKeys);
                question.setRightKey(String.join((CharSequence)",", (CharSequence[])rightKeys));
            }
            if (!QuestionTypeEnum.radio.getType().equals(question.getQuestionType()) && !QuestionTypeEnum.multi.getType().equals(question.getQuestionType()) && !QuestionTypeEnum.judge.getType().equals(question.getQuestionType())) continue;
            if (result.equals(question.getRightKey())) {
                question.setActualScore(question.getScore());
                question.setIsRight("1");
            } else {
                question.setActualScore(BigDecimal.ZERO);
                question.setIsRight("0");
            }
            totalScore = totalScore.add(question.getActualScore());
        }
        this.userRecordDetailManager.updateBatchById(list);
        log.info("\u95ee\u9898\u8be6\u60c5\uff1a{}", (Object)JSON.toJSONString((Object)list));
        record.setSysScore(totalScore);
        this.userRecordManager.updateById((Object)record);
    }

    private void createUserTask(ExamReqVo reqVo, BigDecimal timeLength) {
        String key = CodePrefix.PAPER_TASK_KEY.getKey() + ":" + reqVo.getRecordId();
        Long time = timeLength.longValue() * 60L;
        this.redisUtil.set(key, JSON.toJSON((Object)reqVo), time.longValue());
    }

    private void getBalanceAwswerTime(ExamReqVo reqVo) {
        String key = CodePrefix.PAPER_TASK_KEY.getKey() + ":" + reqVo.getRecordId();
        Object taskInfo = this.redisUtil.get(key);
        Assert.notNull((Object)taskInfo, (String)"\u8003\u8bd5\u5df2\u7ed3\u675f");
    }
}

