/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.attachmentService;

import cn.hutool.core.io.IoUtil;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.OSSObject;
import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.AliyunOssSettings;
import com.artfess.file.model.FileStorage;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FileStorageManager;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import org.springframework.stereotype.Service;

@Service
public class AliyunOssAttachmentServiceImpl
implements AttachmentService {
    private AliyunOssSettings initOssSettings(Attachment attachment, String propertiesId) {
        AliyunOssSettings ossSettings = (AliyunOssSettings)AppUtil.getBean(AliyunOssSettings.class);
        this.setObjectKeyAndFilePath(attachment, ossSettings);
        if (StringUtil.isNotEmpty((String)propertiesId)) {
            FileStorageManager fileStorageManager = (FileStorageManager)AppUtil.getBean(FileStorageManager.class);
            FileStorage fileStorage = (FileStorage)fileStorageManager.get((Serializable)((Object)propertiesId));
            if (BeanUtils.isNotEmpty((Object)((Object)fileStorage))) {
                ossSettings.setEndpoint(fileStorage.getEndpoint());
                ossSettings.setAccessKeyId(fileStorage.getAccessKeyId());
                ossSettings.setAccessKeySecret(fileStorage.getAccessKeySecret());
                ossSettings.setBucketName(fileStorage.getLocation());
                attachment.setEntryptName(Boolean.valueOf(fileStorage.getEncryptName() != 0));
                this.setObjectKeyAndFilePath(attachment, ossSettings);
                return ossSettings;
            }
            FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
            FlowUploadPropertiesStorageDTO uploadProperties = uploadPropertiesManager.getById(propertiesId);
            if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
                ossSettings.setEndpoint(uploadProperties.getEndpoint());
                ossSettings.setAccessKeyId(uploadProperties.getAccessKeyId());
                ossSettings.setAccessKeySecret(uploadProperties.getAccessKeySecret());
                ossSettings.setBucketName(uploadProperties.getLocation());
                attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
                this.setObjectKeyAndFilePath(attachment, ossSettings);
                return ossSettings;
            }
        }
        return ossSettings;
    }

    private void setObjectKeyAndFilePath(Attachment attachment, AliyunOssSettings ossSettings) {
        String fileParentPath = "";
        String filePath = attachment.getFilePath();
        if (StringUtil.isNotEmpty((String)filePath)) {
            fileParentPath = Paths.get(filePath, new String[0]).getParent().toString();
            if ((fileParentPath = fileParentPath.replaceAll("\\\\", "/")).startsWith("/")) {
                fileParentPath = fileParentPath.substring(1);
            }
        }
        filePath = attachment.getEntryptName() != false ? fileParentPath + "/" + attachment.getId() + "." + attachment.getExtensionName() : fileParentPath + "/" + attachment.getId() + "_" + attachment.getFileName() + "." + attachment.getExtensionName();
        ossSettings.setObjectKey(filePath);
        attachment.setFilePath(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Attachment attachment, String propertiesId) throws Exception {
        AliyunOssSettings ossSettings = this.initOssSettings(attachment, propertiesId);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            ossClient.deleteObject(ossSettings.getBucketName(), ossSettings.getObjectKey());
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        AliyunOssSettings ossSettings = this.initOssSettings(attachment, propertiesId);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            ossClient.putObject(ossSettings.getBucketName(), ossSettings.getObjectKey(), inputStream);
            String string = "http://" + ossSettings.getBucketName() + "." + ossSettings.getEndpoint() + "/" + ossSettings.getObjectKey();
        }
        finally {
            inputStream.close();
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        AliyunOssSettings ossSettings = this.initOssSettings(attachment, propertiesId);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try (OSSObject ossObject = ossClient.getObject(ossSettings.getBucketName(), ossSettings.getObjectKey());){
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            IoUtil.copy((InputStream)ossObject.getObjectContent(), (OutputStream)outStream);
        }
        finally {
            outStream.close();
            ossClient.shutdown();
        }
    }

    public String getStoreType() {
        return "aliyunOss";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean chekckFile(Attachment attachment, String propertiesId) throws Exception {
        AliyunOssSettings ossSettings = this.initOssSettings(attachment, propertiesId);
        OSS ossClient = new OSSClientBuilder().build(ossSettings.getEndpoint(), ossSettings.getAccessKeyId(), ossSettings.getAccessKeySecret());
        try {
            boolean found;
            if (!ossClient.doesBucketExist(ossSettings.getBucketName())) {
                ossClient.createBucket(ossSettings.getBucketName());
            }
            boolean bl = found = ossClient.doesObjectExist(ossSettings.getBucketName(), ossSettings.getObjectKey());
            return bl;
        }
        finally {
            ossClient.shutdown();
        }
    }

    public byte[] getFileBytes(Attachment attachment) throws Exception {
        return null;
    }

    public String initMultiPartUpload(Attachment attachment) {
        return null;
    }

    public String getChunkUrl(Attachment attachment, Integer partNumber, String uploadId) {
        return null;
    }

    public boolean mergeMultipartUpload(Attachment attachment, String uploadId, int realyPartNumber) {
        return false;
    }
}

