package com.artfess.bpm.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.bpm.persistence.model.BpmExeStackRelation;

import java.util.List;

/**
 * 堆栈关系表 处理实现类
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author zhangxianwen
 * @email zhangxw@jee-soft.cn
 * @date 2018年6月28日
 */
public interface BpmExeStackRelationManager extends BaseManager<BpmExeStackRelation>{
	/**
	 * 根据堆栈ID获取关系记录
	 * @param stackId
	 *  是在ToStackId位置还是以FromStackId字段：to,from
	 * @return
	 */
     BpmExeStackRelation getByToStackId(String stackId);
     /**
 	 * 根据堆栈ID获取关系记录
 	 * @param isToOrFrom
 	 *  是在ToStackId位置还是以FromStackId字段：to,from
 	 * @return
 	 */
     BpmExeStackRelation getByFromStackId(String stackId);
     
	 List<BpmExeStackRelation> getListByProcInstId(String procInstId);
	 
	 /**
	 * 删除bpm_exe_stack_his 历史数据
	 * @param instId
	 */
	void removeHisByInstId(String procInstId);

    BpmExeStackRelation getById(String instId,String fromId, String toId);
    
    /**
     * 根据实例id和目标节点id获取上来源节点任务堆栈
     * @param instId
     * @param toNodeId
     * @return
     */
    List<BpmExeStackRelation> getByToNodeId(String instId,String toNodeId);
}
