package com.artfess.bpm.persistence.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

 /**
 * 流程水印
 * <pre>
 * 描述：流程水印 实体对象
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-09-02 16:54:36
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
 @TableName("bpm_watermark")
 @ApiModel(value = "BpmWatermark",description = "流程水印")
public class BpmWatermark extends AutoFillModel<BpmWatermark> {

	private static final long serialVersionUID = 1L;
	@XmlTransient
	@TableId("ID_")
	@ApiModelProperty(value="主键")
	protected String id;

	@XmlAttribute(name = "name")
	@TableField("NAME_")
	@ApiModelProperty(value="名称")
	protected String name;

	@XmlAttribute(name = "content")
	@TableField("CONTENT_")
	@ApiModelProperty(value="内容")
	protected String content;

	@XmlAttribute(name = "type")
	@TableField("TYPE_")
	@ApiModelProperty(value="类型 1文字 2图片")
	protected Short type;

	@XmlAttribute(name = "color")
	@TableField("COLOR_")
	@ApiModelProperty(value="颜色 透明度")
	protected String color;

	@XmlAttribute(name = "amount")
	@TableField("AMOUNT_")
	@ApiModelProperty(value="页面展示数量")
	protected Integer amount;

	public void setId(String id) {
		this.id = id;
	}

	/**
	 * 返回 主键
	 * @return
	 */
	public String getId() {
		return this.id;
	}
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * 返回 名称
	 * @return
	 */
	public String getName() {
		return this.name;
	}
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * 返回 内容
	 * @return
	 */
	public String getContent() {
		return this.content;
	}
	public void setType(Short type) {
		this.type = type;
	}

	/**
	 * 返回 类型 1文字 2图片
	 * @return
	 */
	public Short getType() {
		return this.type;
	}
	public void setColor(String color) {
		this.color = color;
	}

	/**
	 * 返回 颜色 透明度
	 * @return
	 */
	public String getColor() {
		return this.color;
	}
	public void setAmount(Integer amount) {
		this.amount = amount;
	}

	/**
	 * 返回 页面展示数量
	 * @return
	 */
	public Integer getAmount() {
		return this.amount;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return new ToStringBuilder(this)
		.append("id", this.id)
		.append("name", this.name)
		.append("content", this.content)
		.append("type", this.type)
		.append("color", this.color)
		.append("amount", this.amount)
		.toString();
	}
}
