/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.CallSubProcessStartEvent;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.persistence.model.BpmExeStackExecutor;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service(value="callSubProcessStartEventListener")
public class CallSubProcessStartEventListener
implements ApplicationListener<CallSubProcessStartEvent>,
Ordered {
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    NatProInstanceService natProInstanceService;

    public void onApplicationEvent(CallSubProcessStartEvent ev) {
        BpmDelegateExecution execution = (BpmDelegateExecution)ev.getSource();
        String nodeId = execution.getNodeId();
        String bpmnDefId = execution.getBpmnDefId();
        String nodeName = execution.getNodeName();
        Map<String, Object> variables = execution.getVariables();
        Integer completeInstance = (Integer)variables.get("nrOfCompletedInstances");
        this.removeVars(variables);
        ContextThreadUtil.cleanCommuVars();
        ContextThreadUtil.setCommuVars(variables);
        String instId = (String)execution.getVariable("instanceId_");
        if (completeInstance == null) {
            this.bpmProStatusManager.createOrUpd(instId, bpmnDefId, nodeId, nodeName, NodeStatus.PENDING);
        }
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        DefaultBpmTask bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        String targetNode = bpmTask.getNodeId();
        cmd.addTransitVars("target_node", targetNode);
        bpmTask.setId(execution.getId());
        bpmTask.setNodeId(nodeId);
        bpmTask.setName(nodeName);
        bpmTask.setIsGateWay(true);
        ContextThreadUtil.addTask(bpmTask);
        try {
            this.bpmExeStackManager.pushStack(execution);
            this.updStack(bpmTask, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void removeVars(Map<String, Object> variables) {
        variables.remove("loopCounter");
        variables.remove("nrOfActiveInstances");
        variables.remove("nrOfCompletedInstances");
        variables.remove("nrOfInstances");
        variables.remove("parentStack");
    }

    public int getOrder() {
        return 1;
    }

    private void updStack(BpmTask bpmTask, ActionCmd cmd) {
        BpmExeStack bpmExeStack;
        String token;
        Object tokenObj = this.natProInstanceService.getVariable(bpmTask.getExecId(), "token_");
        String string = token = tokenObj == null ? null : tokenObj.toString();
        if (token == null) {
            BpmDelegateTask task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
            String string2 = token = task.getVariable("token_") != null ? task.getVariable("token_").toString() : null;
        }
        if ((bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), token)) == null) {
            bpmExeStack = this.bpmExeStackManager.getStack(bpmTask.getProcInstId(), bpmTask.getNodeId(), null);
        }
        if (bpmExeStack == null) {
            return;
        }
        bpmExeStack.setEndTime(LocalDateTime.now());
        this.bpmExeStackManager.update((Model)bpmExeStack);
        BpmExeStackExecutor executor = this.bpmExeStackExecutorManager.getByTaskId(bpmTask.getId());
        cmd.addTransitVars("parentStack", (Object)bpmExeStack);
        if (executor == null) {
            List<BpmExeStackExecutor> executorList = this.bpmExeStackExecutorManager.getByStackId(bpmExeStack.getId());
            if (executorList.size() == 1) {
                executor = executorList.get(0);
            } else {
                return;
            }
        }
        executor.setAssigneeId(ContextUtil.getCurrentUserId());
        executor.setEndTime(LocalDateTime.now());
        this.bpmExeStackExecutorManager.update((Model)executor);
    }
}

