/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.model;

import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.util.Assert;

public class HtObjectNode
extends ObjectNode {
    private static final long serialVersionUID = 1L;

    public HtObjectNode(HtJsonNodeFactory nc) {
        super((JsonNodeFactory)nc);
    }

    public HtObjectNode(HtJsonNodeFactory nc, ObjectNode objectNode) {
        this(nc);
        this.setAll(objectNode);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String defaultVal) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(key), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        JsonNode jsonNode = super.get(key);
        if (jsonNode == null) {
            return defaultVal;
        }
        return jsonNode.asText();
    }

    public Integer getInt(String key, Integer defaultVal) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(key), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        JsonNode jsonNode = super.get(key);
        if (jsonNode == null) {
            return defaultVal;
        }
        return jsonNode.asInt();
    }

    public Integer getInt(String fieldName) {
        return this.getInt(fieldName, null);
    }

    public Double getDouble(String key, Double defaultVal) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(key), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        JsonNode jsonNode = super.get(key);
        if (jsonNode == null) {
            return defaultVal;
        }
        return jsonNode.asDouble();
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Boolean getBoolean(String fieldName, Boolean defaultValue) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(fieldName), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        JsonNode jsonNode = super.get(fieldName);
        if (jsonNode == null || !jsonNode.isBoolean()) {
            return defaultValue;
        }
        return jsonNode.asBoolean();
    }

    public Boolean getBoolean(String fieldName) {
        return this.getBoolean(fieldName, false);
    }

    public Long getLong(String fieldName, Long defaultValue) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(fieldName), (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        JsonNode jsonNode = super.get(fieldName);
        if (jsonNode == null || !jsonNode.isLong()) {
            return defaultValue;
        }
        return jsonNode.asLong();
    }

    public Long getLong(String fieldName) {
        return this.getLong(fieldName, null);
    }

    public ArrayNode getSubTableData(String subTableName) {
        ObjectNode subMap;
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        if (super.hasNonNull("subMap") && (subMap = (ObjectNode)super.get("subMap")).hasNonNull(subTableName)) {
            arrayNode = (ArrayNode)subMap.get(subTableName);
        }
        return arrayNode;
    }

    public void setSubFiledVal(String subTableName, String filedName, Object value) {
        ArrayNode subDatas = this.getSubTableData(subTableName);
        for (JsonNode sub : subDatas) {
            ObjectNode sNode = (ObjectNode)sub;
            if (BeanUtils.isNotEmpty(sNode) && sNode.has("data")) {
                sNode = (ObjectNode)sNode.get("data");
            }
            JsonUtil.putObjectToJson(sNode, filedName, value);
        }
    }

    public void setSubFiledVal(String subTableName, String filedName, Object value, int index) {
        ArrayNode subDatas = this.getSubTableData(subTableName);
        if (subDatas.size() <= index) {
            return;
        }
        ObjectNode sNode = (ObjectNode)subDatas.get(index);
        if (BeanUtils.isNotEmpty(sNode) && sNode.has("data")) {
            sNode = (ObjectNode)sNode.get("data");
        }
        JsonUtil.putObjectToJson(sNode, filedName, value);
    }

    public void setSunFiledVal(String subTableName, String sunTableName, String filedName, Object value) {
        ArrayNode subDatas = this.getSubTableData(subTableName);
        if (subDatas.size() <= 0) {
            return;
        }
        for (int i = 0; i < subDatas.size(); ++i) {
            ArrayNode sunArray;
            String sunName;
            ObjectNode sNode = (ObjectNode)subDatas.get(i);
            if (!sNode.has(sunName = "sub_" + sunTableName) || (sunArray = (ArrayNode)sNode.get("sub_" + sunTableName)).size() <= 0) continue;
            for (int j = 0; j < sunArray.size(); ++j) {
                ObjectNode sunNode = (ObjectNode)sunArray.get(j);
                if (BeanUtils.isNotEmpty(sunNode) && sunNode.has("data")) {
                    sunNode = (ObjectNode)sunNode.get("data");
                }
                JsonUtil.putObjectToJson(sunNode, filedName, value);
            }
            JsonUtil.putObjectToJson(sNode, sunName, sunArray);
        }
    }

    public void setSunFiledVal(String subTableName, String sunTableName, String filedName, Object value, int subIndex) {
        ArrayNode sunArray;
        String sunName;
        ArrayNode subDatas = this.getSubTableData(subTableName);
        if (subDatas.size() <= subIndex) {
            return;
        }
        ObjectNode sNode = (ObjectNode)subDatas.get(subIndex);
        if (sNode.has(sunName = "sub_" + sunTableName) && (sunArray = (ArrayNode)sNode.get("sub_" + sunTableName)).size() > 0) {
            for (int j = 0; j < sunArray.size(); ++j) {
                ObjectNode sunNode = (ObjectNode)sunArray.get(j);
                if (BeanUtils.isNotEmpty(sunNode) && sunNode.has("data")) {
                    sunNode = (ObjectNode)sunNode.get("data");
                }
                JsonUtil.putObjectToJson(sunNode, filedName, value);
            }
            JsonUtil.putObjectToJson(sNode, sunName, sunArray);
        }
    }

    public void setSunFiledVal(String subTableName, String sunTableName, String filedName, Object value, int subIndex, int sunIndex) {
        ArrayNode sunArray;
        String sunName;
        ArrayNode subDatas = this.getSubTableData(subTableName);
        if (subDatas.size() <= subIndex) {
            return;
        }
        ObjectNode sNode = (ObjectNode)subDatas.get(subIndex);
        if (sNode.has(sunName = "sub_" + sunTableName) && (sunArray = (ArrayNode)sNode.get("sub_" + sunTableName)).size() > sunIndex) {
            ObjectNode sunNode = (ObjectNode)sunArray.get(sunIndex);
            if (BeanUtils.isNotEmpty(sunNode) && sunNode.has("data")) {
                sunNode = (ObjectNode)sunNode.get("data");
            }
            JsonUtil.putObjectToJson(sunNode, filedName, value);
            JsonUtil.putObjectToJson(sNode, sunName, sunArray);
        }
    }
}

