/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ThreadMsgUtil
implements ContextThread {
    private static ThreadLocal<List<String>> localMsg = new ThreadLocal();
    private static ThreadLocal<Map<String, String>> localMapMsg = new ThreadLocal();
    private static ThreadLocal<Map<String, LinkedHashSet<String>>> localMapMsg2 = new ThreadLocal();
    public static final String MSG_FLOW_ERROR = "msg_flow_error";

    public static void addMsg(String msg) {
        List<String> list = localMsg.get();
        if (BeanUtils.isEmpty(list)) {
            list = new ArrayList<String>();
            list.add(msg);
            localMsg.set(list);
        } else {
            list.add(msg);
        }
    }

    public static List<String> getMsg() {
        return ThreadMsgUtil.getMsg(true);
    }

    public static List<String> getMsg(boolean clean) {
        List<String> list = localMsg.get();
        if (clean) {
            localMsg.remove();
        }
        return list;
    }

    public static String getMessage() {
        return ThreadMsgUtil.getMessage(true);
    }

    public static String getMessage(boolean clean) {
        List<String> list = ThreadMsgUtil.getMsg(clean);
        String str = "";
        if (BeanUtils.isEmpty(list)) {
            return str;
        }
        for (String msg : list) {
            str = str + msg + "\r\n";
        }
        return str;
    }

    public static void clean() {
        localMsg.remove();
    }

    public static void addMapMsg(String key, String msg) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, String>();
        }
        map.put(key, msg);
        localMapMsg.set(map);
    }

    public static String getMapMsg(String key) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static String getMapMsg(String key, boolean clean) {
        Map<String, String> map = localMapMsg.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            String msg = map.get(key);
            if (clean) {
                map.remove(key);
            }
            return msg;
        }
        return null;
    }

    public static void cleanMapMsg() {
        localMapMsg.remove();
    }

    public static void addMapMsg2(String key, LinkedHashSet<String> msgs) {
        Map<String, LinkedHashSet<String>> map = localMapMsg2.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, LinkedHashSet<String>>();
        }
        map.put(key, msgs);
        localMapMsg2.set(map);
    }

    public static void addMapMsg2(String key, String msg) {
        LinkedHashSet<String> msgs;
        Map<String, LinkedHashSet<String>> map = localMapMsg2.get();
        if (BeanUtils.isEmpty(map)) {
            map = new HashMap<String, LinkedHashSet<String>>();
        }
        if ((msgs = ThreadMsgUtil.getMapMsg2(key)) == null) {
            msgs = new LinkedHashSet();
        }
        msgs.add(msg);
        map.put(key, msgs);
        localMapMsg2.set(map);
    }

    public static LinkedHashSet<String> getMapMsg2(String key) {
        Map<String, LinkedHashSet<String>> map = localMapMsg2.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static LinkedHashSet<String> getMapMsg2(String key, boolean clean) {
        Map<String, LinkedHashSet<String>> map = localMapMsg2.get();
        if (BeanUtils.isEmpty(map)) {
            return null;
        }
        if (map.containsKey(key)) {
            LinkedHashSet<String> msgs = map.get(key);
            if (clean) {
                map.remove(key);
            }
            return msgs;
        }
        return null;
    }

    public static void cleanMapMsg2() {
        localMapMsg2.remove();
    }

    @Override
    public void cleanAll() {
        ThreadMsgUtil.clean();
        ThreadMsgUtil.cleanMapMsg();
        ThreadMsgUtil.cleanMapMsg2();
    }
}

