/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.filter;

import com.artfess.base.interceptor.ResultSetFilter;
import com.artfess.base.util.SQLUtil;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClobDataResultSetFilter
implements ResultSetFilter {
    @Override
    public void handle(Object obj) {
        if (obj instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)obj;
            for (HashMap data : arrayList) {
                if (!(data instanceof HashMap)) continue;
                for (String key : data.keySet()) {
                    if (!(data.get(key) instanceof Clob)) continue;
                    Clob clob = (Clob)data.get(key);
                    try {
                        data.put(key, clob.getSubString(1L, (int)clob.length()));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean support(String id, String sql, List<String> tableNames) {
        String dbType = SQLUtil.getDbType();
        if ("oracle".equals(dbType) || "dm".equals(dbType)) {
            ArrayList<String> mappedStatementIds = new ArrayList<String>();
            mappedStatementIds.add("com.artfess.bpm.persistence.dao.BpmProcessInstanceDao.getHandledByUserId");
            mappedStatementIds.add("com.artfess.base.dao.CommonDao.query");
            mappedStatementIds.add("com.artfess.base.dao.CommonDao.queryByPage");
            mappedStatementIds.add("com.artfess.base.dao.CommonDao.queryByCustomSql");
            mappedStatementIds.add("com.artfess.base.dao.CommonDao.queryByQueryFilter");
            if (mappedStatementIds.contains(id)) {
                return true;
            }
        }
        return false;
    }
}

