/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms.impl;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.persistence.manager.MessageLogManager;
import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.mail.model.MailLing;
import com.artfess.mail.model.MailSetting;
import com.artfess.mail.util.MailUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MailHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(MailHandler.class);
    @Resource
    MessageLogManager messageLogManager;
    @Value(value="${mail.username}")
    private String username;
    @Value(value="${mail.host}")
    private String sendHost;
    @Value(value="${mail.port}")
    private String sendPort;
    @Value(value="${mail.password}")
    private String password;
    @Resource
    BaseContext baseContext;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public String getType() {
        return NoticeMessageType.MAIL.key();
    }

    @Override
    public boolean send(JmsMessage jmsMessage) {
        try {
            List recievers = jmsMessage.getReceivers();
            String strReceiver = this.getMailAddress(recievers);
            if (StringUtil.isEmpty((String)strReceiver)) {
                return false;
            }
            MailSetting mailSetting = new MailSetting();
            mailSetting.setSendHost(this.sendHost);
            mailSetting.setSendPort(this.sendPort);
            mailSetting.setMailAddress(this.username);
            mailSetting.setPassword(this.password);
            MailLing mail = new MailLing();
            mail.setTo(strReceiver);
            mail.setFrom(this.username);
            mail.setSubject(jmsMessage.getSubject());
            mail.setContent(jmsMessage.getContent());
            MailUtil mailUtil = null;
            String tenantId = this.baseContext.getCurrentTenantId();
            ObjectNode infoNode = this.ucFeignService.getTenantMailServiceInfo(tenantId);
            if (BeanUtils.isNotEmpty((Object)infoNode)) {
                MailSetting seting = this.getBymailSetting(infoNode);
                mailUtil = new MailUtil(seting);
            } else {
                mailUtil = new MailUtil(mailSetting);
            }
            mailUtil.sendEmail(mail);
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, "");
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, e.getMessage());
            return false;
        }
    }

    private MailSetting getBymailSetting(ObjectNode infoNode) throws Exception {
        MailSetting seting = new MailSetting();
        String userName = JsonUtil.getString((JsonNode)infoNode, (String)"userName", (String)"");
        String protocal = JsonUtil.getString((JsonNode)infoNode, (String)"mailType", (String)"");
        seting.setProtocal(protocal);
        seting.setMailAddress(userName);
        seting.setPassword(JsonUtil.getString((JsonNode)infoNode, (String)"mailPass", (String)""));
        seting.setNickName(JsonUtil.getString((JsonNode)infoNode, (String)"nickName", (String)""));
        String useSsl = JsonUtil.getString((JsonNode)infoNode, (String)"useSsl", (String)"");
        seting.setSSL(Boolean.valueOf(!"0".equals(useSsl)));
        seting.setValidate(Boolean.valueOf(true));
        seting.setIsDeleteRemote(Boolean.valueOf(false));
        seting.setIsHandleAttach(Boolean.valueOf(true));
        seting.setMailType(JsonUtil.getString((JsonNode)infoNode, (String)"mailType", (String)""));
        seting.setReceiveHost(JsonUtil.getString((JsonNode)infoNode, (String)"mailHost", (String)""));
        seting.setReceivePort(JsonUtil.getString((JsonNode)infoNode, (String)"mailPort", (String)""));
        String s = userName.substring(userName.indexOf(64) + 1, userName.length()).trim();
        seting.setSmtpHost("smtp." + s);
        seting.setSmtpPort("25");
        seting.setSendHost(seting.getSmtpHost());
        seting.setSendPort(seting.getSmtpPort());
        return seting;
    }

    private String getMailAddress(List<JmsActor> recievers) {
        if (BeanUtils.isEmpty(recievers)) {
            return "";
        }
        StringBuilder toUserEmail = new StringBuilder();
        for (JmsActor iUser : recievers) {
            String email = iUser.getEmail();
            if (StringUtil.isEmpty((String)email)) continue;
            toUserEmail.append(",");
            toUserEmail.append(email);
        }
        String result = toUserEmail.toString();
        result = result.replaceFirst(",", "");
        return result;
    }

    @Override
    public String getTitle() {
        return "\u90ae\u4ef6";
    }

    @Override
    public boolean getIsDefault() {
        return false;
    }

    @Override
    public boolean getSupportHtml() {
        return true;
    }
}

