/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.query.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DmpBeanUtil;
import com.artfess.query.dao.BizQueryResultMainDao;
import com.artfess.query.manager.BizQueryResultConditionManager;
import com.artfess.query.manager.BizQueryResultMainManager;
import com.artfess.query.model.BizQueryResultCondition;
import com.artfess.query.model.BizQueryResultMain;
import com.artfess.query.vo.BizQueryResultVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizQueryResultMainManagerImpl
extends BaseManagerImpl<BizQueryResultMainDao, BizQueryResultMain>
implements BizQueryResultMainManager {
    @Autowired
    BizQueryResultConditionManager queryResultConditionManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean saveOrUpdateBatchResult(BizQueryResultVo queryResultVo) throws Exception {
        if (BeanUtils.isNotEmpty((Object)((Object)queryResultVo))) {
            List<BizQueryResultCondition> list = queryResultVo.getQueryResultCondition();
            List fields = list.stream().map(t -> t.getFieldName()).collect(Collectors.toList());
            List disFields = fields.stream().distinct().collect(Collectors.toList());
            if (fields.size() != disFields.size()) {
                throw new ApplicationException("\u8bbe\u7f6e\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d");
            }
            if (queryResultVo.getSn() == null) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("TAG_ID_", queryResultVo.getTagId());
                Integer sn = this.getNextSequence(param);
                queryResultVo.setSn(sn);
            }
            if (queryResultVo.getShowType() == 3) {
                queryResultVo.setGroupName("\u4e3b\u8868\u4fe1\u606f");
            }
            this.saveOrUpdate((Object)queryResultVo);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MIAN_ID_", (Object)queryResultVo.getId());
            this.queryResultConditionManager.remove((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty(list)) {
                for (BizQueryResultCondition resultCondition : list) {
                    resultCondition.setMianId(queryResultVo.getId());
                    if (resultCondition.getSn() != null) continue;
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("MIAN_ID_", queryResultVo.getId());
                    Integer sn = this.getNextSequence(param);
                    resultCondition.setSn(sn);
                }
                this.queryResultConditionManager.saveOrUpdateBatch(list);
            }
            return true;
        }
        return false;
    }

    @Override
    public BizQueryResultVo getVoById(String id) {
        Assert.hasText((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizQueryResultMain main = (BizQueryResultMain)((Object)this.getById((Serializable)((Object)id)));
        if (main != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"MIAN_ID_", (Object)id);
            queryWrapper.orderByAsc((Object)"SN_");
            List list = this.queryResultConditionManager.list((Wrapper)queryWrapper);
            BizQueryResultVo vo = new BizQueryResultVo();
            DmpBeanUtil.copyProperties((Object)((Object)main), (Object)((Object)vo));
            vo.setQueryResultCondition(list);
            return vo;
        }
        return null;
    }

    @Override
    public List<BizQueryResultVo> qureyResultConfigByTag(String tagId) {
        Assert.hasText((String)tagId, (String)"\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<BizQueryResultVo> queryResultVoList = new ArrayList<BizQueryResultVo>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TAG_ID_", (Object)tagId);
        queryWrapper.orderByAsc((Object)"SN_");
        List list = ((BizQueryResultMainDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List mainIds = list.stream().filter(resultMain -> resultMain != null).map(BizQueryResultMain::getId).collect(Collectors.toList());
            QueryWrapper queryConditionWrapper = new QueryWrapper();
            queryConditionWrapper.in((Object)"MIAN_ID_", mainIds);
            queryConditionWrapper.orderByAsc((Object[])new String[]{"MIAN_ID_", "SN_"});
            List conditionList = this.queryResultConditionManager.list((Wrapper)queryConditionWrapper);
            Map<String, List<BizQueryResultCondition>> conditionMap = conditionList.stream().collect(Collectors.groupingBy(BizQueryResultCondition::getMianId));
            for (BizQueryResultMain main : list) {
                BizQueryResultVo vo = new BizQueryResultVo();
                DmpBeanUtil.copyProperties((Object)((Object)main), (Object)((Object)vo));
                List<BizQueryResultCondition> mainConditionList = conditionMap.get(main.getId());
                vo.setQueryResultCondition(mainConditionList);
                queryResultVoList.add(vo);
            }
            return queryResultVoList;
        }
        return Collections.emptyList();
    }
}

