/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.algorithm.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmTaskinfoDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmReasonManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmRelationManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmTaskinfoManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmVersionManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.model.BizAlgorithmTaskinfo;
import com.artfess.dataShare.algorithm.model.BizAlgorithmVersion;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizAlgorithmTaskinfoManagerImpl
extends BaseManagerImpl<BizAlgorithmTaskinfoDao, BizAlgorithmTaskinfo>
implements BizAlgorithmTaskinfoManager {
    @Resource
    BizAlgorithmVersionManager versionManager;
    @Resource
    BizAlgorithmReasonManager reasonManager;
    @Resource
    BizAlgorithmRelationManager relationManager;

    @Override
    @Transactional
    public void deploy(String id, String versionId, String routineName) throws Exception {
        BizAlgorithmTaskinfo taskinfo = (BizAlgorithmTaskinfo)((Object)this.getById((Serializable)((Object)id)));
        BizAlgorithmVersion version = (BizAlgorithmVersion)((Object)this.versionManager.getById((Serializable)((Object)versionId)));
        version.setVersionPublishTime(LocalDateTime.now());
        IUser user = ContextUtil.getCurrentUser();
        version.setVersionPublishUser(user.getUsername());
        this.versionManager.update((Model)version);
        taskinfo.setDeployedTime(LocalDateTime.now());
        taskinfo.setDeployedVersion(version.getVersionCode());
        taskinfo.setRoutineName(routineName);
        taskinfo.setDeployedUsername(user.getUsername());
        taskinfo.setDeployedStatus("4");
        this.update((Model)taskinfo);
    }

    @Override
    public void updateDeployedStatus(String id, String deployedStatus) throws Exception {
        BizAlgorithmTaskinfo taskinfo = (BizAlgorithmTaskinfo)((Object)this.getById((Serializable)((Object)id)));
        taskinfo.setDeployedStatus(deployedStatus);
        this.update((Model)taskinfo);
    }

    @Override
    @Transactional
    public void saveTaskInfo(BizAlgorithmTaskinfo taskinfo) throws Exception {
        taskinfo.setDeployedStatus("1");
        this.saveOrUpdate((Object)taskinfo);
    }

    @Override
    @Transactional
    public void saveAsTaskInfo(String versionId, String versionName, String versionCode) throws Exception {
        BizAlgorithmVersion version = (BizAlgorithmVersion)((Object)this.versionManager.getById((Serializable)((Object)versionId)));
        if (null == version) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u7248\u672c\u3002");
        }
        String newId = UniqueIdUtil.getSuid();
        version.setId(newId);
        version.setVersionName(versionName);
        version.setVersionCode(versionCode);
        this.versionManager.save((Object)version);
        List<BizAlgorithmReason> reasons = this.reasonManager.queryByVersionId(versionId);
        HashMap<String, String> idMaps = new HashMap<String, String>();
        for (BizAlgorithmReason item : reasons) {
            String oldId = item.getId();
            item.setId(null);
            item.setTaskVersonId(newId);
            if (null != idMaps.get(item.getParentId())) {
                item.setParentId((String)idMaps.get(item.getParentId()));
            } else {
                item.setParentId("-1");
            }
            this.reasonManager.saveReason(item);
            idMaps.put(oldId, item.getId());
        }
    }
}

