import req from "@/request.js";
import {Promise} from "q";

const uc = window.context.uc;

export default {
    //获取分组
    getFgroupList(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/fgroup/list',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //删除分组
    deleteFgroupList(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/fgroup/delete', data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //添加分组
    addFgroupList(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/fgroup/add', data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //编辑分组
    editFgroupList(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/fgroup/edit', data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //获取群
    getQgroupList(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/qgroup/list',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //新建群
    addQgroup(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/qgroup/add',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //解散群
    deleteQgroup(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/qgroup/delete',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //查询群成员
    queryQgroupPer(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/qgroup/groupMembers',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //踢出群成员
    kickoutPer(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/qgroup/kickout',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //查询群聊天记录
    hismsgList(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/hismsg/list',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },

    //删除聊天记录
    deleteHismsg(data){
        return new Promise((resolve, reject) => {
            req.post(uc + '/hismsg/delete',data).then(rep => {
                resolve(rep.data);
            }).catch(error => {
                reject(error.message);
            })
        })
    },
}
