//风场总览 ---------------------------------- start
//风场总览  --> 地图模式
const MapModel = () => import('@/views/WindFarmOverview/MapModel.vue')

//风场总览  --> 标准模式
const StandardModel = () => import('@/views/WindFarmOverview/StandardModel.vue')

//风场总览  --> 机组模式
const CrewOverview = () => import('@/views/WindFarmOverview/CrewOverview.vue')

//风场总览 ---------------------------------- end

//电网控制 ---------------------------- start
//电网控制  --> 无功控制
const ReactivePower = () => import('@/views/GridControl/ReactivePower.vue')

//电网控制  --> 有功控制
const ActivePower = () => import('@/views/GridControl/ActivePower.vue')
//电网控制 ---------------------------- end

//全息监测 ---------------------------- start
//全息监测  --> 设备监测
const EquipmentMonitor = () =>
  import('@/views/HolographicMonitor/EquipmentMonitor.vue')

//全息监测  --> 实时数据
const LiveData = () => import('@/views/HolographicMonitor/LiveData.vue')
//全息监测 ---------------------------- end

//智能决策 ---------------------------- start
//智能决策  --> 智能决策
const IntelligentDecision = () => import('@/views/IntelligentControl/IntelligentDecision.vue')
//智能决策  --> 模型管理
const ModelManagement = () => import('@/views/IntelligentControl/ModelManagement.vue')
//智能决策 ---------------------------- end

//场群协同 ---------------------------- start
//场群协同  --> 分组信息
const GroupingInfo = () => import('@/views/GroupCoordination/GroupingInfo.vue')
//场群协同  --> 群组控制
const GroupControl = () => import('@/views/GroupCoordination/GroupControl.vue')
//场群协同  --> 载赫安全控制
const LoadSafety = () => import('@/views/GroupCoordination/LoadSafety.vue')
//场群协同 ---------------------------- end

//状态预测 ---------------------------- start
//状态预测  --> 故障预警
const FaultEarlyWarning = () =>
  import('@/views/StatePrediction/FaultEarlyWarning.vue')
//状态预测  --> 寿命预测
const LifePrediction = () =>
  import('@/views/StatePrediction/LifePrediction.vue')
//状态预测 ---------------------------- end

//健康管理 ---------------------------- start
//健康管理   --> 健康管理
const HealthManage = () => import('@/views/HealthManage/HealthManage.vue')
//健康管理   --> 寿命调度
const OptimalSchedule = () => import('@/views/HealthManage/OptimalSchedule.vue')
//健康管理   --> 体检报告
const HealthForm = () => import('@/views/HealthManage/HealthForm.vue')
//健康管理 ---------------------------- end

export default {
  MapModel,
  StandardModel,
  CrewOverview,
  ReactivePower,
  ActivePower,
  EquipmentMonitor,
  LiveData,
  IntelligentDecision,
  ModelManagement,
  GroupingInfo,
  GroupControl,
  LoadSafety,
  FaultEarlyWarning,
  HealthManage,
  OptimalSchedule,
  HealthForm,
  LifePrediction
}
