package com.artfess.cqlt.vo;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--产品销售数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
@Data
@ApiModel(value="QfOperationSalesProductD对象", description="运营--产品销售数据填报详情表")
public class SalesProductDetailVo extends BaseModel<SalesProductDetailVo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "主表ID")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    private LocalDate fillDate;

    @Excel(name = "product", column = "A")
    @ApiModelProperty(value = "产品")
    private String product;

    @Excel(name = "Actual", column = "B")
    @ApiModelProperty(value = "当月实际销售额")
    private BigDecimal actual;

    @Excel(name = "Budget", column = "C")
    @ApiModelProperty(value = "当月预算销售额")
    private BigDecimal budget;

    @Excel(name = "Deviation abs.", column = "D")
    @ApiModelProperty(value = "当月销售差额")
    private BigDecimal deviation;


    @ApiModelProperty(value = "当月销售偏差率(%)")
    private BigDecimal deviationRate;

    @Excel(name = "Deviation(%)", column = "E")
    @ApiModelProperty(value = "当月销售偏差率(%)")
    private String deviationRateStr;


    @Excel(name = "ActualYTD", column = "F")
    @ApiModelProperty(value = "当年累计实际销售额")
    private BigDecimal actualYtd;

    @Excel(name = "BudgetYTD", column = "G")
    @ApiModelProperty(value = "当年累计预算销售额")
    private BigDecimal budgetYtd;

    @Excel(name = "DeviationabsYtd", column = "H")
    @ApiModelProperty(value = "当年累计销售差额")
    private BigDecimal deviationYtd;

    @ApiModelProperty(value = "当年销售偏差率(%)")
    private BigDecimal deviationRateYtd;

    @Excel(name = "DeviationYtd(%)", column = "I")
    @ApiModelProperty(value = "当年销售偏差率(%)")
    private String deviationRateYtdStr;

    @ApiModelProperty(value = "最终编辑时间")
    private LocalDateTime lastTime = LocalDateTime.now();


}
