package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 国内外科目对应关系
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-13
 */
@Data
@ApiModel(value="QfSubjectRelation对象", description="国内外科目对应关系")
public class QfSubjectRelation extends BaseModel<QfSubjectRelation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "国际科目编码")
    @TableField("inter_code_")
    private String interCode;

    @ApiModelProperty(value = "国际科目ID")
    @TableField("inter_id_")
    private String interId;

    @ApiModelProperty(value = "国内科目ID")
    @TableField("sub_id_")
    private String subId;

    @ApiModelProperty(value = "国内科目编码")
    @TableField("sub_code_")
    private String subCode;

    @ApiModelProperty(value = "国际科目转换公式")
    @TableField("expression_")
    private String expression;

    @ApiModelProperty(value = "国际科目名称")
    @TableField(exist = false)
    private String internationalName;

    @ApiModelProperty(value = "科目类型")
    @TableField(exist = false)
    private String type;

}
