package com.artfess.cqlt.model;

import java.math.BigDecimal;

import com.artfess.base.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资金--欧元同业拆借利率详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-07-17
 */
@Data
@ApiModel(value="QfEuroRatesD对象", description="资金--欧元同业拆借利率详情表")
public class QfEuroRatesD extends BaseModel<QfEuroRatesD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "类型", column = "A")
    @ApiModelProperty(value = "类型：1M,2M,3M")
    @TableField("type_")
    private String type;

    @ApiModelProperty(value = "月份")
    @TableField("month_")
    private String month;

    @ApiModelProperty(value = "填报值")
    @TableField("fill_data_")
    private BigDecimal fillData;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
